<?php

function resize_image($file, $w, $h, $crop=FALSE) {
    list($width, $height) = getimagesize($file);
    $r = $width / $height;
    if ($crop) {
        if ($width > $height) {
            $width = ceil($width-($width*($r-$w/$h)));
        } else {
            $height = ceil($height-($height*($r-$w/$h)));
        }
        $newwidth = $w;
        $newheight = $h;
    } else {
        if ($w/$h > $r) {
            $newwidth = $h*$r;
            $newheight = $h;
        } else {
            $newheight = $w/$r;
            $newwidth = $w;
        }
    }
    $src = imagecreatefromjpeg($file);
    $dst = imagecreatetruecolor($newwidth, $newheight);
    imagecopyresampled($dst, $src, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);

    return $dst;
}

if ( $_GET['album'] ) {
	$album = urldecode($_GET['album']);
} else {
	echo "Fish cakes.\n";
	die;
}

if ( $_GET['track'] ) {
	$track = $_GET['track'];
	$mode = "pod";
} else {
	$mode = "image";
}

if ( $_GET['size'] ) {
	$size = $_GET['size'];
} else {
	$size = 1;
}

require("config.php");

$coversperrow = $settings['cpr'];

$smallcoversize = intval($settings['smallcoverarea'] / $coversperrow);
$largecoversize = $settings['largecoversize'];

$resizeimages = $settings['resizeimages'];
$imagecache = $settings['imagecache'];
$coverfile = $settings['coverfile'];
$cachejpgquality = $settings['cachejpgquality'];
$podjpgquality = $settings['podjpgquality'];

if ( ! ( ( $size == $smallcoversize ) || ( $size == $largecoversize ) ) ) {
	if ( $resizeimages == "yes" && $mode == "image" ) {
		echo "Get your own Gimp.";
		die;
	}
}

if ( $mode == "pod" ) {
	foreach ( array_keys($libraries) as $library ) {
		$dirpath = $library."/".$album;
		if ( file_exists($dirpath) ) {
			// found it
			break;
		}
	}
	if ( ! file_exists("$dirpath") ) {
		echo "Can't find album ".$album.". Aborting.\n";
		die;
	}
	$coverpath = $dirpath."/".$coverfile;
	if ( ! file_exists($coverpath) ) {
		echo "Can'f find cover file at ".$coverpath.".\n";
		die;
	}
	$background_hash = $imagecache."/".sha1("background-".$coverpath."-".filemtime($coverpath)).".png";
	if ( ! file_exists($background_hash) ) {
		// TODO FIXME this needs to be ported to PHP + Imagick.
		`convert -verbose -resize 1280x1280 -blur 0x16 -modulate 50,50 '$coverpath' -crop 1280x720+0+280 -draw "image over 75,100 500,500 '$coverpath'" $background_hash`;
	}

	$pod_hash = $imagecache."/".sha1($track."-".$coverpath."-".filemtime($coverpath)).".jpg";
	if ( ! file_exists($pod_hash) ) {
		foreach ( array_keys($libraries) as $library ) {
		        $dirpath = $library."/".$album;
		        if ( is_dir($dirpath) ) {
			break;
        		}
		}

		$albumdir = $dirpath."/";
		foreach ( glob($albumdir."*.mp3") as $file ) {
			if ( is_file($file) ) {
				require_once('getid3/getid3.php');
				$getID3 = new getID3;
				$finfo = $getID3->analyze($file);
				if ( @$finfo['tags']['id3v2']['track'][0] == $track || @$finfo['tags']['id3v1']['track'][0] == $track ) { 
					break;
				}
			}
		}

		$song['artist'] = @$finfo['tags']['id3v2']['artist'][0];
	        if ( ! $song['artist'] ) {
        	        $song['artist'] = @$finfo['tags']['id3v1']['artist'][0];
        	}
		$song_artist = str_replace("'","’",$song['artist']);
	
		$song['album'] = @$finfo['tags']['id3v2']['album'][0];
                if ( ! $song['album'] ) {
	                $song['album'] = @$finfo['tags']['id3v1']['album'][0];
 	        }
		$song_album = str_replace("'","’",$song['album']);

		$song['title'] = @$finfo['tags']['id3v2']['title'][0];
		if ( ! $song['title'] ) {
			$song['title'] = @$finfo['tags']['id3v1']['title'][0];
		}
		$song_title = str_replace("'","’",$song['title']);

		// TODO FIXME this needs to be ported to PHP + Imagick.
		// TODO FIXME add configurability
		`convert "$background_hash" -font Helvetica -pointsize 40 -draw "fill black text 653,563 '$song_album' fill orange text 650,560 '$song_album'" -pointsize 60 -draw "fill black text 653,623 '$song_artist' fill orange text 650,620 '$song_artist'" -pointsize 15 -draw "fill white text 650,700 'Track $track'" -pointsize 20 -draw "fill white text 650,730 '$song_title'" -quality $podjpgquality $pod_hash`;
	}
	header("Content-Type: image/jpg");
	header("Content-Length: " . filesize($pod_hash));
	$fp = fopen($pod_hash, "r");
        fpassthru($fp);
        fclose($fp);
	die;

} else { // image mode
	 // find the album in libraries
	foreach ( array_keys($libraries) as $library ) {
		$dirpath = $library."/".$album;
		if ( file_exists($dirpath) ) {
			// found it
			break;
		}
	}
	if ( ! file_exists("$dirpath") ) {
		echo "Can't find album ".$album.". Aborting.\n";
		die;
	}
	$coverpath = $dirpath."/".$coverfile;
	if ( ! file_exists($coverpath) ) {
		echo "Can'f find cover file at ".$coverpath.".\n";
		die;
	}

	if ( $resizeimages == "no" ) {
		$fp = fopen("$coverpath", "r");
		header("Content-Type: image/jpg");
		header("Content-Length: " . filesize($coverpath));
		fpassthru($fp);
		fclose($fp);
		die;
	}

	$cache_hash = $imagecache."/".sha1($coverpath."-".$size."-".filemtime($coverpath)).".jpg";
	header("Content-Type: image/jpg");
	if ( ! file_exists($cache_hash) ) {
		$img = resize_image($coverpath,$size,$size);
		imagejpeg($img,$cache_hash,$cachejpgquality);
		imagedestroy($img);
	}
	header("Content-Length: " . filesize($cache_hash));
	$fp = fopen($cache_hash, "r");
	fpassthru($fp);
	fclose($fp);
}
?>
