<?php

require("config.php");
require_once('getid3/getid3.php');

function array_sort_func($a,$b=NULL) {
   static $keys;
   if($b===NULL) return $keys=$a;
   foreach($keys as $k) {
      if(@$k[0]=='!') {
         $k=substr($k,1);
         if(@$a[$k]!==@$b[$k]) {
            return strcmp(@$b[$k],@$a[$k]);
         }
      }
      else if(@$a[$k]!==@$b[$k]) {
         return strcmp(@$a[$k],@$b[$k]);
      }
   }
   return 0;
}

function array_sort(&$array) {
   if(!$array) return $keys;
   $keys=func_get_args();
   array_shift($keys);
   array_sort_func($keys);
   usort($array,"array_sort_func");       
} 

if ($_GET['page']) {
	$page = $_GET['page'];
} else {
	$page = $defaults['page'];
}

if ($_GET['order']) {
	$order = $_GET['order'];
} else {
	$order = $defaults['order'];
}

if ($_GET['filter']) {
	$filter = $_GET['filter'];
} else {
	$filter = "";
}

if ($_GET['start']) {
	$start = $_GET['start'];
} else {
	$start = $defaults['start'];
}

$coversperrow = $settings['cpr'];
$rowsperpage = $settings['rpp'];
$wwwroot = $settings['wwwroot'];

$coversperpage = $coversperrow * $rowsperpage;
$smallcoversize = intval($settings['smallcoverarea'] / $coversperrow);

$counter = 0;
$albums = array();
$getID3 = new getID3;

foreach ( array_keys($libraries) as $library ) {

	$dir_handle = @opendir($library);
	while ($dir = readdir($dir_handle)) {
		$sort_artist = split("_-_",$dir,2);
		$sort_album = split("_-_",$dir,2);
		$pattern = "/^".$filter."/";	
		if ( $page == "artist" ) {
			$subject = $sort_artist[0];
		} elseif ( $page == "album" ) {
			$subject = $sort_album[1];
		} else {
			echo "ASSERT in page type";
			die;
		}
		if ( $dir != "." && $dir != ".." && $dir != ".Browse" && is_dir("$library/$dir") && preg_match("$pattern",preg_replace("/^A_/","",preg_replace("/^The_/","",$subject))) ) {
			$counter = $counter + 1;
			$urlpath = str_replace("$wwwroot", "/", "$library");

			$filepath = $library."/".$dir."/*.mp3";
			foreach ( glob("$filepath") as $file ) {
				break;
			}
			$albums [$counter]['ondisk_artist'] = $sort_artist[0];
			$albums [$counter]['ondisk_album'] = $sort_album[1];
			$albums [$counter]['sort_artist'] = preg_replace("/^A_/","",preg_replace("/^The_/","",$sort_artist[0]));
			$albums [$counter]['sort_album'] = preg_replace("/^A_/","",preg_replace("/^The_/","",$sort_album[1]));
			$albums [$counter]['library'] = $library;
			$albums [$counter]['directory'] = $dir;
			$albums [$counter]['url'] = $urlpath."/".basename($dir);
			$albums [$counter]['firstfile'] = $file;

		}
	}
	closedir($dir_handle);

}

$sortkey = "sort_".$page;

array_sort($albums,$sortkey);

$albumcount = $counter;

$modulo = $albumcount% $coversperpage;

if ( $modulo = 0 ) {
	$pagecount = intval($albumcount / $coversperpage);
} else {
	$pagecount = intval($albumcount / $coversperpage) + 1;
}

$firstpage = 1;
$currentpage = $start;
$lastpage = $pagecount;

if ( $currentpage == $firstpage ) {
	$nextpage = $currentpage + 1;
	$prevpage = $lastpage;
} elseif ( $currentpage == $lastpage ) {
	$nextpage = $firstpage;
	$prevpage = $currentpage - 1;
} else {
	$nextpage = $currentpage + 1;
	$prevpage = $currentpage - 1;
}

if ( $pagecount == 1 ) {
	$nextpage = $currentpage;
	$prevpage = $currentpage;
}

require("res/html/browser.tpl");

$utf8_string = 'Iñtërnâtiônàlizætiøn';
echo $page." - ".$filter;
 

echo "\t\t\t<tr>\n";

$row = 1;
$tempcounter = 1;
for ($i = ($currentpage * $coversperpage)-($coversperpage); $i < $albumcount; $i++) {
$coverart = $albums[$i]['url']."/".$settings['coverfile'];

	echo "\t\t\t\t<td>\n";

	$trans = array("&" => "%26");
	$safealbum = strtr($albums[$i]['directory'],$trans);

	echo "\t\t\t\t\t<a href=\"album.php?album=".$safealbum."\" name=\"".$tempcounter."\" onfocus=\"show(".$tempcounter.")\" onblur=\"hide(".$tempcounter.")\"><img src=\"".$coverart."\" onmouseover=\"show(".$tempcounter.")\" onmouseout=\"hide(".$tempcounter.")\" WIDTH=".$smallcoversize." HEIGHT=".$smallcoversize." /></a>\n";

	$tempcounter = $tempcounter + 1;
	echo "\t\t\t\t</td>\n";
	if ( (($i+1) % $coversperrow) == 0) {
		echo "</tr>\n";
		echo "<tr>\n";
		$row = $row + 1;
	}
	if ( $row == $rowsperpage + 1) {
		break;
	}
	
}

echo "</tr>\n";
echo "\t\t</table>\n";
echo "\t\t<br/>\n";
echo "\t\t<center>\n";
echo "                <table class=\"title\" width=\"100%\"><tr><td id=\"title\" align=\"center\"> </td></tr></table></td></tr></table>\n";


$row = 1;
$tempcounter = 1;

for ($i = ($currentpage * $coversperpage)-($coversperpage); $i < $albumcount; $i++) {
	if ( (($i+1) % $coversperrow) == 0) {
		$row = $row + 1;
	}
	$fileinfo = $getID3->analyze($albums[$i]['firstfile']);
	$albums_sorted[$i]['album'] = @$fileinfo['tags']['id3v2']['album'][0];
	if ( ! $albums_sorted[$i]['album']) {
		$albums_sorted[$i]['album'] = @$fileinfo['tags']['id3v1']['album'][0];
	}
	$albums_sorted[$i]['artist'] = @$fileinfo['tags']['id3v2']['artist'][0];
	if ( ! $albums_sorted[$i]['artist'] ) {
	$albums_sorted[$i]['artist'] = @$fileinfo['tags']['id3v1']['artist'][0];
	}
	echo "                <div class=title id=title".$tempcounter.">".$albums_sorted[$i]['artist']." - ".$albums_sorted[$i]['album']."</div>\n";
	$tempcounter = $tempcounter + 1;
	if ( $row == $rowsperpage + 1) {
		break;
	}
}

echo "                <div class=\"title\">\n<a TVID=\"HOME\" href=\"browser.php\">Home</a>\n<a name=\"pgdnload\" onfocusload=\"\" href=\"browser.php?page=".$page."&start=".$nextpage."&order=".$order."&filter=".$filter."\"/><a name=\"pgupload\" onfocusload=\"\" href=\"browser.php?page=".$page."&start=".$prevpage."&order=".$order."&filter=".$filter."\"/>\n</div>\n</center>\n</body>\n</html>";


?>
