<?php

require("config.php");
require_once('getid3/getid3.php');

if ($_GET['album']) {
	$album = $_GET['album'];
} else {
	echo "Error, album not selected. Going down in flames.";
	die;
}



$utf8_string = 'Iñtërnâtiônàlizætiøn';


$getID3 = new getID3;


foreach ( array_keys($libraries) as $library ) {
	$dirpath = $library."/".$album;
	if ( is_dir($dirpath) ) {
		break;
	}
	
}

$albumdir = $dirpath."/";

$wwwroot = $settings['wwwroot'];

$counter = 0;
foreach ( glob($albumdir."*.mp3") as $file ) {
	$counter = $counter + 1;
	$urlpath = $libraries["$library"];
	$song[$counter]['filepath'] = $file;
	$song[$counter]['urlpath'] = $urlpath."/".$album."/".basename($file);
	
	$fileinfo = $getID3->analyze($song[$counter]['filepath']);
	//print_r($fileinfo);
	
	$song[$counter]['artist'] = @$fileinfo['tags']['id3v2']['artist'][0];
	if ( ! $song[$counter]['artist'] ) {
		$song[$counter]['artist'] = @$fileinfo['tags']['id3v1']['artist'][0];
	}

	$song[$counter]['album'] = @$fileinfo['tags']['id3v2']['album'][0];
	if ( ! $song[$counter]['album'] ) {
		$song[$counter]['album'] = @$fileinfo['tags']['id3v1']['album'][0];
	}	
	
	$song[$counter]['title'] = @$fileinfo['tags']['id3v2']['title'][0];
	if ( ! $song[$counter]['title'] ) {
		$song[$counter]['title'] = @$fileinfo['tags']['id3v1']['title'][0];
	}
	$song[$counter]['track'] = @$fileinfo['tags']['id3v2']['track'][0];
	if ( ! $song[$counter]['track'] ) {
		$song[$counter]['track'] = @$fileinfo['tags']['id3v1']['track'][0];
	}

	if ( ! $song[$counter]['track'] ) {
		$song[$counter]['track'] = @$fileinfo['tags']['id3v2']['track_number'][0];
		if ( preg_match("/\//",$song[$counter]['track']) ) {
			$track_extract = split("/",$song[$counter]['track']);
			$song[$counter]['track'] = $track_extract[0];
		}
	}

	$song[$counter]['duration'] = intval(@$fileinfo['playtime_seconds']);
}

	$bitrate = @$fileinfo['audio']['bitrate'];
	if ( $bitrate ) {
		$song[1]['bitrate'] = ( $bitrate / 1000 )."kbps";
	} else {
		$song[1]['bitrate'] = "unknown";
	}

	$dataformat = @$fileinfo['audio']['dataformat'];
	if ( $dataformat ) {
		$song[1]['dataformat'] = $dataformat;
	} else {
		$song[1]['dataformat'] = "unknown";
	}

	$coverurl = $urlpath."/".$album."/".$settings['coverfile'];
		
/*
echo "<!--\n";
for ($i = 1; $i <= $counter; $i++) {
	echo "artist: ".$song[$i]['artist']."\n";
	echo "album: ".$song[$i]['album']."\n";
	echo "title: ".$song[$i]['title']."\n";
	echo "track: ".$song[$i]['track']."\n";
	echo "file: ".$song[$i]['filepath']."\n";
	echo "bitrate: ".$song[$i]['bitrate']."\n";
	echo "url: ".$song[$i]['urlpath']."\n\n";
}
echo "-->\n";
*/

header("Content-Type: audio/x-scpls");
header("Content-Disposition: attachment; filename=$album".".pls");
echo "[playlist]\n";
echo "numberofentries=".$counter."\n";

for ($i = 1; $i <= $counter; $i++) {
	echo "File".$i."=".$song[$i]['urlpath']."\n";
	echo "Title".$i."=".$song[$i]['title']."\n";
	echo "Length".$i."=-1\n";
}
?>
