#!/bin/bash

. ./musicbox.conf || exit 1

function get_title()
{
	mediainfo -f $FILE | dos2unix | grep "Album" | grep -v "replay gain" | cut -d ':' -f 2- | head -n 1 | cut -d ' ' -f 2- | sed -e "s/'/’/g"
}

function get_artist()
{
	mediainfo -f $FILE | dos2unix | grep "Performer" | cut -d ':' -f 2- | head -n 1 | cut -d ' ' -f 2- | sed -e "s/'/’/g"
}

function get_track_name()
{
	mediainfo -f $FILE | dos2unix |grep "Track name" | grep -v "Position" | cut -d ':' -f 2- | head -n 1 | cut -d ' ' -f 2- | sed -e "s/'/’/g"
}

function get_track_number()
{
	mediainfo -f $FILE | dos2unix | grep "Track name/Position" | cut -d ':' -f 2- | head -n 1 | cut -d ' ' -f 2-
}

function get_codec()
{
	mediainfo -f $FILE | dos2unix | grep "Codec" | grep -v "profile" | tail -n 1 | cut -d ':' -f 2- | head -n 1 | cut -d ' ' -f 2- | sed -e "s/'/’/g"
}

function get_bitrate()
{
	mediainfo -f $FILE | dos2unix | grep "Bit rate" | grep -v "mode" | tail -n 1 | cut -d ':' -f 2- | head -n 1 | cut -d ' ' -f 2- | sed -e "s/'/’/g"
}


function get_duration()
{
        DURATION="`mediainfo -f $FILE |dos2unix|grep "Duration"|grep "\."|head -1|cut -d ":" -f 2-|cut -d " " -f 2-`"
        DURATION_HOURS="`echo $DURATION|cut -d ':' -f 1 | sed 's/0*//'`"
        if [ "$DURATION_HOURS" == "" ]
        then
                DURATION_HOURS="0"
        fi
        DURATION_MINUTES="`echo $DURATION|cut -d ':' -f 2 | sed 's/0*//'`"
        if [ "$DURATION_MINUTES" == "" ]
        then
                DURATION_MINUTES="0"
        fi
        DURATION_SECONDS="`echo $DURATION|cut -d ':' -f 3 | cut -d '.' -f 1 | sed 's/0*//'`"
        if [ "$DURATION_SECONDS" == "" ]
        then
                DURATION_SECONDS="0"
        fi
        DURATION_MILISECONDS="`echo $DURATION|cut -d '.' -f 2 | sed 's/0*//'`"
        if [ "$DURATION_MILISECONDS" == "" ]
        then
                DURATION_MILISECONDS="0"
        fi
        DURATION_MS="$[$[ ${DURATION_HOURS} * 3600000] + $[ ${DURATION_MINUTES} * 60000] + $[ ${DURATION_SECONDS} * 1000 ] + ${DURATION_MILISECONDS} ]"
        DURATION_FRAMES=$[$DURATION_MS/100]
	DURATION_FULL_SECONDS=$[$DURATION_MS/1000]
}

function ms2tc()
{
        HOURS=$[ $MS / 3600000 ]
        MINUTES=$[ $[ $MS - $[ $HOURS * 3600000 ] ] / 60000 ]
        SEC=$[ $[ $MS - $[ $HOURS * 3600000 ] - $[ $MINUTES * 60000 ] ] / 1000 ]
        MILLISECONDS=$[ $MS - $[ $HOURS * 3600000 ] - $[ $MINUTES * 60000 ] - $[ $SEC * 1000] ]
        if [ "${#SEC}" = "1" ]
        then
                SEC="0${SEC}"
        fi

        if [ "${#MINUTES}" = "1" ]
        then
                MINUTES="0${MINUTES}"
        fi

        if [ "${#HOURS}" = "1" ]
        then
                HOURS="0${HOURS}"
        fi

        if [ "${#MILLISECONDS}" = "1" ]
        then
                MILLISECONDS="00${MILLISECONDS}"
        fi
        if [ "${#MILLISECONDS}" = "2" ]
        then
                MILLISECONDS="0${MILLISECONDS}"
        fi
	echo "${HOURS}:${MINUTES}:${SEC}.${MILLISECONDS}"
}

function tc2ms()
{
	TC_HOURS="`echo $DURATION|cut -d ':' -f 1 | sed 's/0*//'`"
	if [ "$TC_HOURS" == "" ]
	then
	        TC_HOURS="0"
	fi
	TC_MINUTES="`echo $DURATION|cut -d ':' -f 2 | sed 's/0*//'`"
	if [ "$TC_MINUTES" == "" ]
	then
	        TC_MINUTES="0"
	fi
	TC_SECONDS="`echo $DURATION|cut -d ':' -f 3 | cut -d '.' -f 1 | sed 's/0*//'`"
	if [ "$TC_SECONDS" == "" ]
	then
	        TC_SECONDS="0"
	fi
	TC_MILLISECONDS="`echo $DURATION|cut -d '.' -f 2 | sed 's/0*//'`"
	if [ "$TC_MILLISECONDS" == "" ]
	then
	        TC_MILLISECONDS="0"
	fi
	
	MILLISECONDS="$[$[ ${TC_HOURS} * 3600000] + $[ ${TC_MINUTES} * 60000] + $[ ${TC_SECONDS} * 1000 ] + ${TC_MILLISECONDS} ]"
	
	echo "$MILLISECONDS"
}

mkdir -p ${LIBRARY}/${BROWSER}
cp -af $RESOURCES ${LIBRARY}/${BROWSER}/

# let's scan the library and see what we've got.

echo -en "${GREEN}Scanning ${LIBRARY}${NORMAL}"

HOWDEEPISYOURLOVE="`echo $LIBRARY | grep '/' -o|wc -l`"

ALBUMLIST=""

for ALBUM in `ls $LIBRARY|cut -d '/' -f ${HOWDEEPISYOURLOVE}- | grep -v index.htm`
do
	ALBUMLIST="${ALBUMLIST} ${ALBUM}"
	echo -en "${GREEN}.${NORMAL}"
done

echo ""

echo -en "${GREEN}Found following albums:${NORMAL} "
echo -e "${BOLD}${ALBUMLIST}${NORMAL}"


echo -en "${GREEN}Generating cover art files for the jukebox${NORMAL}"

for ALBUM in $ALBUMLIST
do
	if [ -s "${LIBRARY}/${BROWSER}/${ALBUM}_large.png" ]
	then
		true
	else
		convert	-scale ${LARGE_COVER_SIZE}x${LARGE_COVER_SIZE} ${LIBRARY}/${ALBUM}/${COVER_SOURCE} \
		${LIBRARY}/${BROWSER}/${ALBUM}_large.png
			
	fi

	if [ -s "${LIBRARY}/${BROWSER}/${ALBUM}_small.png" ]
	then
		true
	else
		convert	-scale ${SMALL_COVER_SIZE}x${SMALL_COVER_SIZE} ${LIBRARY}/${ALBUM}/${COVER_SOURCE} \
		${LIBRARY}/${BROWSER}/${ALBUM}_small.png
	fi

	if [ -s "${LIBRARY}/${BROWSER}/${ALBUM}_background.png" ]
	then
		true
	else
		convert \
			-scale 1280x1280 \
			-blur 0x16 \
			-modulate 50,50 \
				${LIBRARY}/${ALBUM}/${COVER_SOURCE} \
			-crop 1280x720+0+280 \
				${LIBRARY}/${BROWSER}/${ALBUM}_background.png
	fi
	echo -en "${GREEN}.${NORMAL}"
done

echo ""
echo -e "${GREEN}Creating ${BOLD}.pod${NORMAL}${GREEN} files for each song on each album.${NORMAL}"

for ALBUM in $ALBUMLIST
do
	echo -en "${BOLD}${ALBUM}${NORMAL}"

	for FILE in `for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done`
	do
		SONGFILE="`basename $FILE`"
		get_duration
		echo "${DURATION_FULL_SECONDS}|1|`get_track_name`|${NMT_ROOT}/${ALBUM}/${SONGFILE}.jpg|" >${LIBRARY}/${ALBUM}/${SONGFILE}.pod
		echo -en "${GREEN}.${NORMAL}"
	done
	echo ""
done


echo -e "${GREEN}Creating ${BOLD}.jpg${NORMAL}${GREEN} image for each song and ${BOLD}$FRAMELIST_FILE${NORMAL}${GREEN} for the album.${NORMAL}"

for ALBUM in $ALBUMLIST
do
	echo -en "${BOLD}${ALBUM}${NORMAL}"

	rm -f $LIBRARY/$ALBUM/$FRAMELIST_FILE	
	
	for FILE in `for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done`
        do
		if [ -s "${FILE}.jpg" ]
		then
			true
		else
			convert ${LIBRARY}/${BROWSER}/${ALBUM}_background.png \
				-draw "image over ${COVER_POSITION} ${COVER_SIZE} '${LIBRARY}/${ALBUM}/${COVER_SOURCE}'" \
				-font ${FONT} -pointsize ${TITLE_SIZE} \
			                -draw "fill black text $TITLE_POSITION2 '$TITLE' fill ${TITLE_COLOUR} text $TITLE_POSITION '`get_title`'" \
			        -pointsize ${ARTIST_SIZE} \
			                -draw "fill black text $ARTIST_POSITION2 '$ARTIST' fill ${ARTIST_COLOUR} text $ARTIST_POSITION '`get_artist`'" \
				-pointsize ${TRACK_NUMBER_SIZE} \
					-draw "fill $TRACK_NUMBER_COLOUR text $TRACK_NUMBER_POSITION 'Track `get_track_number`'" \
				-pointsize $TRACK_NAME_SIZE \
	                		-draw "fill $TRACK_NAME_COLOUR text $TRACK_NAME_POSITION '`get_track_name`'" \
				-quality $JPG_QUALITY \
			${FILE}.jpg
		fi
		if [ -s "$LIBRARY/$ALBUM/$ALBUM.mkv" ]
		then
			true
		else
			get_duration
	
			for N in `seq 1 $DURATION_FRAMES`
			do
				echo "${FILE}.jpg" >>$LIBRARY/$ALBUM/$FRAMELIST_FILE
		        done
		fi
		echo -en "${GREEN}.${NORMAL}"
        done
        echo ""
	if [ -s "$LIBRARY/$ALBUM/$ALBUM.mkv" ]
	then
		true
	else
		# 10 second lead-out on video repeating last frame.
		for N in `seq 1 100`
		do
		        echo "${FILE}.jpg" >>$LIBRARY/$ALBUM/$FRAMELIST_FILE
		done
	fi
done

echo -e "${GREEN}Creating ${BOLD}.chapters${NORMAL}${GREEN} file for the album.${NORMAL}"

for ALBUM in $ALBUMLIST
do
	echo -en "${BOLD}${ALBUM}${NORMAL}"
	if [ -s "$LIBRARY/$ALBUM/$ALBUM.mkv" ]
	then
		true
	else
		MS=0
		CHAPTER=1
		rm -f $LIBRARY/$ALBUM/$ALBUM.chapters
		for FILE in `for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done`
		do
			get_duration		
			MS=$[ ${MS} + `tc2ms` ]
			CHAPTER=$[ $CHAPTER + 1 ]

			echo "CHAPTER${CHAPTER}=`ms2tc`" >>$LIBRARY/$ALBUM/$ALBUM.chapters
			echo "CHAPTER${CHAPTER}NAME=`get_track_name`" >>$LIBRARY/$ALBUM/$ALBUM.chapters
			echo -en "${GREEN}.${NORMAL}"
		done
	fi	
	echo ""
done

echo -e "${GREEN}Creating ${BOLD}.mka${NORMAL}${GREEN} files containing all the music inside each album.${NORMAL}"

for ALBUM in $ALBUMLIST
do
	echo -en "${BOLD}${ALBUM}${NORMAL}"
	if [ -s "$LIBRARY/$ALBUM/$ALBUM.mkv" ]
	then
		true
	else
		if [ -s "$LIBRARY/$ALBUM/$ALBUM.mka" ]
		then
			echo -en "${GREEN}${BOLD}!${NORMAL}"
		else
			COUNTER="1"
			LIST=""
			for FILE in `for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done`
			do
			        if [ "$COUNTER" = "1" ]
			        then
			                PLUS=""
			        else
			                PLUS="+"
			        fi
			        LIST="${LIST} ${PLUS}${FILE}"
			        COUNTER="$[ ${COUNTER} + 1 ]"
				echo -en "${GREEN}.${NORMAL}"
			done
			mkvmerge ${LIST} --title "`get_title`" -o ${LIBRARY}/${ALBUM}/${ALBUM}.mka -r /dev/null
			echo -en "${GREEN}${BOLD}!${NORMAL}"
		fi
	fi
	echo ""
done	
	
echo -e "${GREEN}Creating ${BOLD}.mkv${NORMAL}${GREEN} files.${NORMAL}"

for ALBUM in $ALBUMLIST
do
	echo -en "${BOLD}${ALBUM}${NORMAL}"
	if [ -s "$LIBRARY/$ALBUM/$ALBUM.mkv" ]
	then
		echo -en "${GREEN}${BOLD}!${NORMAL}"
	else
	echo ""
	mencoder mf://@$LIBRARY/$ALBUM/$FRAMELIST_FILE \
                -mf type=jpg:w=1280:h=720:fps=10 \
                -sws 0 \
                -ovc x264 \
                -x264encopts turbo=2:threads=auto:crf=22:level_idc=41:bframes=3:nodct_decimate:trellis=0:nob_pyramid:me=dia:mixed_refs:weight_b \
                -ofps 10 \
                -of rawvideo \
                -o $LIBRARY/$ALBUM/${ALBUM}.x264 

	mkvmerge --default-duration 0:100ms $LIBRARY/$ALBUM/${ALBUM}.x264 $LIBRARY/$ALBUM/${ALBUM}.mka --chapters $LIBRARY/$ALBUM/${ALBUM}.chapters --title "`get_title`" -o $LIBRARY/$ALBUM/${ALBUM}.mkv 
	rm -f $LIBRARY/$ALBUM/${ALBUM}.x264 $LIBRARY/$ALBUM/${ALBUM}.mka $LIBRARY/$ALBUM/${ALBUM}.chapters $LIBRARY/$ALBUM/$FRAMELIST_FILE
	fi
	echo ""
done

echo -e "${GREEN}Creating per-album ${BOLD}.html${NORMAL}${GREEN} files.${NORMAL}"

for ALBUM in $ALBUMLIST
do
	echo -en "${BOLD}${ALBUM}${NORMAL}"
		# ok, this is where we actually do some work.
FILE="`for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done|head -n 1`"
cat <<EOF >${LIBRARY}/${BROWSER}/${ALBUM}.html
<html>
        <head>
                <link rel="StyleSheet" type="text/css" href="item.css"/>
                <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
                <title>`get_title`</title>
                <script type="text/javascript">
var baseFilename = "${ALBUM}";
//
  var title = 1;
  var lnk = 1;
  function lnkt() {
    if ( title == 1 ) title = document.getElementById('title').firstChild;
    if ( lnk == 1 ) lnk = document.getElementById('playLink');
  }
  function show(x) {
    lnkt();
    title.nodeValue = document.getElementById('title'+x).firstChild.nodeValue;
    if(lnk)lnk.setAttribute('HREF', baseFilename + '.playlist' + x + '.jsp');
  }
  function hide() {
    lnkt();
    title.nodeValue = "-";
    if(lnk)lnk.setAttribute('HREF', '');
  }
//
                </script>
        </head>
        <body bgproperties="fixed" background="pictures/background.jpg" onloadset="Play">
                <table class="main" align="center" border="0" cellpadding="0" cellspacing="0">
                        <tr height="30">
                                <td height="50" align="center" colspan="2">
                                        <a TVID="HOME" href="../index.htm"/>
                                        <a TVID="PGDN" href="Next_Album.html"/>
                                        <a TVID="PGUP" href="Prev_Album.html"/>
                                </td>
                        </tr>
                        <tr align="left" valign="top">
                                <td width="500px">
                                        <img src="${ALBUM}_large.png"/>
                                        <center>
                                        <table>
                                                <tr>
                                                        <td class="title1" valign="top" colspan="2">
                                                                `get_title`
                                                        </td>
                                                <tr>
                                                        <td class="title2" colspan="2">
                                                                `get_artist`
                                                        </td>
                                                </tr>
                                                <tr class="divider" colspan="2">
                                                        <td width="150px">

                                                        </td>
                                                </tr>
                                                <tr class="spacer">
                                                        <td>

                                                        </td>
                                                </tr>
                                                <tr>
                                                        <td class="normal" width="45%">
                                                                `get_codec`
                                                        </td>
                                                <tr>
                                                        <td class="normal" width="45%">
                                                                `get_bitrate`
                                                        </td>
                                                </tr>
                                        </table>
                                        </center>
                                </td>
                                <td>
                                        <table border="0" width="85%">
                                                </tr>
                                                <tr>
                                                        <td>
                                                                <table>
                                                                        <tr>
                                                                                <td class="normal">
                                                                                        <a class="link" onfocus="hide()" href="${NMT_ROOT}/${ALBUM}/${ALBUM}.mkv" TVID="Play" name="Play" vod=""><img src="pictures/play_small.png" onfocussrc="pictures/play_selected_small.png" align="top"/>Play all</a>
                                                                                        <div id="title">  </div>
                                                                                </td>
                                                                        </tr>
                                        <!-- TRACKS GO HERE -->
EOF

		ID=0
		for FILE in `for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done`
		do
		NEXTID=$[ $ID + 1 ]
		if [ "$ID" == "0" ]
		then
			PREVID="0"
		else
			PREVID="$[ $ID - 1 ]"
		fi
		SONGFILE="`basename $FILE`"
cat <<EOF >>${LIBRARY}/${BROWSER}/${ALBUM}.html
                                                                       <tr valign="top">
                                                                                <td class="normal">
                                                                                        <a href="${NMT_ROOT}/${ALBUM}/${SONGFILE}" TVID="1" name="e${ID}" onkeyleftset="e${PREVID}" onkeyrightset="e${NEXTID}" onfocus="show(${NEXTID})" onblur="hide()" pod="2,1,${NMT_ROOT}/${ALBUM}/${SONGFILE}.pod">`get_track_number`. `get_track_name`</a>
                                                                                </td>
                                                                        </tr>

EOF
		ID="$[ $ID + 1 ]"
		echo -en "${GREEN}.${NORMAL}"
		done

	echo ""
done

cat <<EOF >>${LIBRARY}/${BROWSER}/${ALBUM}.html
                                        <!-- TRACKS END HERE -->
                                                                </table>
                                                        </td>
                                                </tr>
                                        </table>
                                </td>
                        </tr>
                </table>
        </body>
</html>
EOF

ALBUMCOUNT="`echo $ALBUMLIST | wc -w`"
MODULO="$[ ${ALBUMCOUNT} % ${CPP} ]"

if [ "${MODULO}" == "0" ]
then
	PAGECOUNT=$[ ${ALBUMCOUNT} / ${CPP} ]
else
	PAGECOUNT=$[ $[ ${ALBUMCOUNT} / ${CPP} ] + 1 ]
fi

if [ "${PAGECOUNT}" == "0" ]
then
	PAGECOUNT=1
fi

echo -e "${GREEN}Number of browser index pages required: ${PAGECOUNT} (at $CPP covers per page).${NORMAL}"

echo -e "${GREEN}Building pagemap.${NORMAL}"

PAGEMAP=`mktemp`
COUNTER=1

for ALBUM in $ALBUMLIST
do
	FILE="`for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done |head -n 1`"
	echo "'$COUNTER','$ALBUM','`get_artist`','`get_title`'" >>$PAGEMAP
	COUNTER=$[ $COUNTER + 1 ]
done

function pagemap_title()
{
	grep "^'$ALBUMINDEX'," $PAGEMAP | cut -d ',' -f 4 | cut -d "'" -f 2
}

function pagemap_artist()
{
	grep "^'$ALBUMINDEX'," $PAGEMAP | cut -d ',' -f 3 | cut -d "'" -f 2
}

function pagemap_album()
{
	grep "^'$ALBUMINDEX'," $PAGEMAP | cut -d ',' -f 2 | cut -d "'" -f 2
}

function divmap_title()
{
	grep "^'$ALBUMINDEX2'," $PAGEMAP | cut -d ',' -f 4 | cut -d "'" -f 2
}

function divmap_artist()
{
	grep "^'$ALBUMINDEX2'," $PAGEMAP | cut -d ',' -f 3 | cut -d "'" -f 2
}

function divmap_album()
{
	grep "^'$ALBUMINDEX2'," $PAGEMAP | cut -d ',' -f 2 | cut -d "'" -f 2
}


echo "$CPR columns, $RPP rows, $CPP covers per page"
ROW=1
COLUMN=1
PAGE=1
ALBUMINDEX=1
ALBUMINDEX2=1
for PAGE in `seq 1 $PAGECOUNT`
do
	echo "Processing page $PAGE/$PAGECOUNT"	
	if [ "$PAGE" == "1" ]
	then
		PREVPAGE=$PAGECOUNT
		NEXTPAGE=$[ $PAGE + 1 ]
	else
		PREVPAGE=$[ $PAGE - 1 ]
		NEXTPAGE=$[ $PAGE + 1 ]
	fi
	if [ "$PAGE" == $PAGECOUNT ]
	then
		NEXTPAGE=$PAGECOUNT
		PREVPAGE=$[ $PAGE - 1 ]
	else
		PREVPAGE=$[ $PAGE - 1 ]
		NEXTPAGE=$[ $PAGE + 1 ]
	fi
cat <<EOF >${LIBRARY}/${BROWSER}/Album_${PAGE}.html
<html>
        <head>
                <link rel="StyleSheet" type="text/css" href="browse.css"/>
                <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/><title>$WEBPAGE_TITLE</title>
<script type="text/javascript">
var title = 1;
function show(x)
{
  if ( title == 1 )
    title = document.getElementById('title');
   title.firstChild.nodeValue = document.getElementById('title'+x).firstChild.nodeValue;
}
function hide(x)
{
  if ( title == 1 )
    title = document.getElementById('title');
   title.firstChild.nodeValue = "";
}
</script>
        </head>
        <body bgproperties="fixed" background="pictures/background.jpg" onloadset="1">
                <a href="" tvid="#" id="play" vod="playlist"/>
                <table class="main" border="0" cellpadding="0" cellspacing="0">
                        <tr valign="top">
                                <td COLSPAN="2" align="center">
                                        <a href="Title_09_1.html" name="09">09</a>
                                         - <a href="Title_A_1.html" name="A">A</a>
                                         - <a href="Title_B_1.html" name="B">B</a>
                                         - <a href="Title_C_1.html" name="C">C</a>
                                         - <a href="Title_D_1.html" name="D">D</a>
                                         - <a href="Title_E_1.html" name="E">E</a>
                                         - <a href="Title_F_1.html" name="F">F</a>
                                         - <a href="Title_G_1.html" name="G">G</a>
                                         - <a href="Title_H_1.html" name="H">H</a>
                                         - <a href="Title_I_1.html" name="I">I</a>
                                         - <a href="Title_J_1.html" name="J">J</a>
                                         - <a href="Title_K_1.html" name="K">K</a>
                                         - <a href="Title_L_1.html" name="L">L</a>
                                         - <a href="Title_M_1.html" name="M">M</a>
                                         - <a href="Title_N_1.html" name="N">N</a>
                                         - <a href="Title_O_1.html" name="O">O</a>
                                         - <a href="Title_P_1.html" name="P">P</a>
                                         - <a href="Title_Q_1.html" name="Q">Q</a>
                                         - <a href="Title_R_1.html" name="R">R</a>
                                         - <a href="Title_S_1.html" name="S">S</a>
                                         - <a href="Title_T_1.html" name="T">T</a>
                                         - <a href="Title_U_1.html" name="U">U</a>
                                         - <a href="Title_V_1.html" name="V">V</a>
                                         - <a href="Title_W_1.html" name="W">W</a>
                                         - <a href="Title_X_1.html" name="X">X</a>
                                         - <a href="Title_Y_1.html" name="Y">Y</a>
                                </td>
                        </tr>
                        <tr align="left" valign="top">
                                <td width="120">
                                        <table class="categories" border="0">
                                                <tr>
                                                        <td>
                                                                <a href="Artist_1.html">Artists</a>
                                                        <td>
                                                </tr>
                                                <tr>
                                                        <td>
                                                                <a href="Album_1.html">Albums</a>
                                                        <td>
                                                </tr>
                                                <tr>
                                                        <td>
                                                                <hr>
                                                        </td>
                                                </tr>
                                                <tr>
                                                        <td align="right"><table><tr><td valign="center">
                                                                <div class="counter">${PAGE} / ${PAGECOUNT}</div>
                                                        </td>
                                                        <td valign="top">
                                                                <a name="pgdn" tvid="pgdn" href="Album_$NEXTPAGE.html"><img src="pictures/nav_down.png"/></a>
                                                                <a name="pgup" tvid="pgup" href="Album_$PREVPAGE.html"><img src="pictures/nav_up.png"/></a>
                                                        </td>
                                                </tr>
                                        </table>
                                </td>
                        </tr>
                </table>
        </td>
        <td>
                <table class="movies" border="0">
EOF
	COUNTER=1
	for ROW in `seq 1 $RPP`
	do
		echo "	Processing row $ROW/$RPP"
cat <<EOF >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html
                        <tr>
EOF
		for COLUMN in `seq 1 $CPR`
		do
			echo "		Processing column $COLUMN/$CPR"
cat <<EOF >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html
                        	<td>
EOF
			if [ $ALBUMINDEX -le $ALBUMCOUNT ]
			then
cat <<EOF >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html
                                        <a href="`pagemap_album`.html" TVID="$COUNTER" name="$COUNTER" onfocus="show($COUNTER)" onblur="hide($COUNTER)"><img src="`pagemap_album`_small.png" onmouseover="show($COUNTER)" onmouseout="hide($COUNTER)"/></a>
EOF
			else
				echo "<!-- EMPTY -->" >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html

			fi
			ALBUMINDEX=$[ $ALBUMINDEX + 1 ]
			COUNTER=$[ $COUNTER + 1 ]
cat <<EOF >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html
                        	</td>
EOF
		done
cat <<EOF >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html
                        </tr>
EOF
	done
	

cat <<EOF >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html
                </table>
                <br/>
                <center>
                <table class="title" width="100%"><tr><td id="title" align="center"> </td></tr></table></td></tr></table>
EOF
	COUNTER=1
	for ROW in `seq 1 $RPP`
	do
		for COLUMN in `seq 1 $CPR`
		do
			if [ $ALBUMINDEX2 -le $ALBUMCOUNT ]
			then
				echo "                <div class="title" id="title${COUNTER}">`divmap_artist` - `divmap_title`</div>" >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html
			else
				echo "<!-- EMPTY -->" >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html

			fi
			ALBUMINDEX2=$[ $ALBUMINDEX2 + 1 ]
			COUNTER=$[ $COUNTER + 1 ]
		done
	done


cat <<EOF >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html
                <div class="title">
                        <a TVID="HOME" href="../index.htm">Home</a>
                        <a name="pgdnload" onfocusload="" href="Album_$NEXTPAGE.html"/><a name="pgupload" onfocusload="" href="Album_$PREVPAGE.html"/>
                </div>
                </center>
        </body>
</html>
EOF

done

rm -f $PAGEMAP
