#!/bin/bash

. ./musicbox.conf || exit 1

function get_title()
{
	mediainfo -f $FILE | dos2unix | grep "^Album" | grep -v "replay gain" | cut -d ':' -f 2- | head -n 1 | cut -d ' ' -f 2- | sed -e "s/'/’/g"
}

function get_artist()
{
	mediainfo -f $FILE | dos2unix | grep "^Performer" | cut -d ':' -f 2- | head -n 1 | cut -d ' ' -f 2- | sed -e "s/'/’/g"
}

function get_track_name()
{
	mediainfo -f $FILE | dos2unix |grep "^Track name" | grep -v "Position" | cut -d ':' -f 2- | head -n 1 | cut -d ' ' -f 2- | sed -e "s/'/’/g"
}

function get_track_number()
{
	mediainfo -f $FILE | dos2unix | grep "^Track name/Position" | cut -d ':' -f 2- | head -n 1 | cut -d ' ' -f 2-
}

function get_codec()
{
	mediainfo -f $FILE | dos2unix | grep "^Codec" | grep -v "profile" | tail -n 1 | cut -d ':' -f 2- | head -n 1 | cut -d ' ' -f 2- | sed -e "s/'/’/g"
}

function get_bitrate()
{
	mediainfo -f $FILE | dos2unix | grep "^Bit rate" | grep -v "mode" | tail -n 1 | cut -d ':' -f 2- | head -n 1 | cut -d ' ' -f 2- | sed -e "s/'/’/g"
}


function get_duration()
{
        DURATION="`mediainfo -f $FILE |dos2unix|grep "Duration"|grep "\."|head -1|cut -d ":" -f 2-|cut -d " " -f 2-`"
        DURATION_HOURS="`echo $DURATION|cut -d ':' -f 1 | sed 's/0*//'`"
        if [ "$DURATION_HOURS" == "" ]
        then
                DURATION_HOURS="0"
        fi
        DURATION_MINUTES="`echo $DURATION|cut -d ':' -f 2 | sed 's/0*//'`"
        if [ "$DURATION_MINUTES" == "" ]
        then
                DURATION_MINUTES="0"
        fi
        DURATION_SECONDS="`echo $DURATION|cut -d ':' -f 3 | cut -d '.' -f 1 | sed 's/0*//'`"
        if [ "$DURATION_SECONDS" == "" ]
        then
                DURATION_SECONDS="0"
        fi
        DURATION_MILISECONDS="`echo $DURATION|cut -d '.' -f 2 | sed 's/0*//'`"
        if [ "$DURATION_MILISECONDS" == "" ]
        then
                DURATION_MILISECONDS="0"
        fi
        DURATION_MS="$[$[ ${DURATION_HOURS} * 3600000] + $[ ${DURATION_MINUTES} * 60000] + $[ ${DURATION_SECONDS} * 1000 ] + ${DURATION_MILISECONDS} ]"
        DURATION_FRAMES=$[$DURATION_MS/100]
	DURATION_FULL_SECONDS=$[$DURATION_MS/1000]
}

function ms2tc()
{
        HOURS=$[ $MS / 3600000 ]
        MINUTES=$[ $[ $MS - $[ $HOURS * 3600000 ] ] / 60000 ]
        SEC=$[ $[ $MS - $[ $HOURS * 3600000 ] - $[ $MINUTES * 60000 ] ] / 1000 ]
        MILLISECONDS=$[ $MS - $[ $HOURS * 3600000 ] - $[ $MINUTES * 60000 ] - $[ $SEC * 1000] ]
        if [ "${#SEC}" = "1" ]
        then
                SEC="0${SEC}"
        fi

        if [ "${#MINUTES}" = "1" ]
        then
                MINUTES="0${MINUTES}"
        fi

        if [ "${#HOURS}" = "1" ]
        then
                HOURS="0${HOURS}"
        fi

        if [ "${#MILLISECONDS}" = "1" ]
        then
                MILLISECONDS="00${MILLISECONDS}"
        fi
        if [ "${#MILLISECONDS}" = "2" ]
        then
                MILLISECONDS="0${MILLISECONDS}"
        fi
	echo "${HOURS}:${MINUTES}:${SEC}.${MILLISECONDS}"
}

function tc2ms()
{
	TC_HOURS="`echo $DURATION|cut -d ':' -f 1 | sed 's/0*//'`"
	if [ "$TC_HOURS" == "" ]
	then
	        TC_HOURS="0"
	fi
	TC_MINUTES="`echo $DURATION|cut -d ':' -f 2 | sed 's/0*//'`"
	if [ "$TC_MINUTES" == "" ]
	then
	        TC_MINUTES="0"
	fi
	TC_SECONDS="`echo $DURATION|cut -d ':' -f 3 | cut -d '.' -f 1 | sed 's/0*//'`"
	if [ "$TC_SECONDS" == "" ]
	then
	        TC_SECONDS="0"
	fi
	TC_MILLISECONDS="`echo $DURATION|cut -d '.' -f 2 | sed 's/0*//'`"
	if [ "$TC_MILLISECONDS" == "" ]
	then
	        TC_MILLISECONDS="0"
	fi
	
	MILLISECONDS="$[$[ ${TC_HOURS} * 3600000] + $[ ${TC_MINUTES} * 60000] + $[ ${TC_SECONDS} * 1000 ] + ${TC_MILLISECONDS} ]"
	
	echo "$MILLISECONDS"
}

mkdir -p ${LIBRARY}/${BROWSER}
cp -af $RESOURCES ${LIBRARY}/${BROWSER}/

# let's scan the library and see what we've got.

echo -en "${GREEN}Scanning ${LIBRARY}${NORMAL}"

HOWDEEPISYOURLOVE="`echo $LIBRARY | grep '/' -o|wc -l`"

ALBUMLIST=""

for ALBUM in `ls $LIBRARY|cut -d '/' -f ${HOWDEEPISYOURLOVE}- | grep -v index.htm`
do
	ALBUMLIST="${ALBUMLIST} ${ALBUM}"
	echo -en "${GREEN}.${NORMAL}"
done

#ALBUMLIST="Air_-_Moon_Safari"

echo ""

echo -en "${GREEN}Found following albums:${NORMAL} "
echo -e "${BOLD}${ALBUMLIST}${NORMAL}"


echo -en "${GREEN}Generating cover art files for the jukebox${NORMAL}"

for ALBUM in $ALBUMLIST
do
	if [ -s "${LIBRARY}/${ALBUM}/${COVER_SOURCE}" ]
	then
		THECOVER="${LIBRARY}/${ALBUM}/${COVER_SOURCE}"
		HAVECOVER=1
	else
		THECOVER="${LIBRARY}/${BROWSER}/pictures/default_cover.jpg"	
		HAVECOVER=0
		echo ""
		echo "Warning: ${ALBUM} lacks coverart, using placeholder."
	fi
	if [ -d "${LIBRARY}/${BROWSER}/${ALBUM}_data" ]
	then
		true
	else
		mkdir -p "${LIBRARY}/${BROWSER}/${ALBUM}_data"
	fi

	if [ -s "${LIBRARY}/${BROWSER}/${ALBUM}_large.png" ] && [ "${HAVECOVER}" = "1" ]
	then
		true
	else
		convert	-resize "${LARGE_COVER_SIZE}x${LARGE_COVER_SIZE}"\! "${THECOVER}" \
		"${LIBRARY}/${BROWSER}/${ALBUM}_large.png"
			
	fi

	if [ -s "${LIBRARY}/${BROWSER}/${ALBUM}_small.png" ] && [ "${HAVECOVER}" = "1" ]
	then
		true
	else
		convert	-resize "${SMALL_COVER_SIZE}x${SMALL_COVER_SIZE}"\! "${THECOVER}" \
		"${LIBRARY}/${BROWSER}/${ALBUM}_small.png"
	fi

	if [ -s "${LIBRARY}/${BROWSER}/${ALBUM}_background.png" ] && [ "${HAVECOVER}" = "1" ]
	then
		true
	else
		convert \
			-resize 1280x1280\! \
			-blur 0x16 \
			-modulate 50,50 \
				"${THECOVER}" \
			-crop 1280x720+0+280 \
				"${LIBRARY}/${BROWSER}/${ALBUM}_background.png"
	fi
	echo -en "${GREEN}.${NORMAL}"
done

echo ""
echo -e "${GREEN}Creating ${BOLD}.pod${NORMAL}${GREEN} files for each song on each album.${NORMAL}"

for ALBUM in $ALBUMLIST
do
	if [ "$GENERATE_PODS" == "0" ]
	then
		echo ".pod and .pls generation skipped (see config)."
		break
	fi
	echo -en "${BOLD}${ALBUM}${NORMAL}"
	rm -f "${LIBRARY}/${BROWSER}/${ALBUM}_data/${ALBUM}.pod"
	echo "[playlist]" >"${LIBRARY}/${BROWSER}/${ALBUM}.pls"
	echo "numberofentries=`for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done|wc -l`" >>"${LIBRARY}/${BROWSER}/${ALBUM}.pls"
	PLS=1
	for FILE in `for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done`
	do
		SONGFILE="`basename "$FILE"`"
		get_duration
		echo "${DURATION_FULL_SECONDS}|1|`get_track_name`|${NMT_ROOT}/${BROWSER}/${ALBUM}_data/${SONGFILE}.jpg|" >"${LIBRARY}/${BROWSER}/${ALBUM}_data/${SONGFILE}.pod"
		echo "${DURATION_FULL_SECONDS}|1|`get_track_name`|${NMT_ROOT}/${BROWSER}/${ALBUM}_data/${SONGFILE}.jpg|" >>"${LIBRARY}/${BROWSER}/${ALBUM}_data/${ALBUM}.pod"
		echo >>"${LIBRARY}/${BROWSER}/${ALBUM}.pls" "File${PLS}=${NMT_ROOT}/${ALBUM}/${SONGFILE}"
		echo >>"${LIBRARY}/${BROWSER}/${ALBUM}.pls" "Title${PLS}=`get_track_name`"
		echo >>"${LIBRARY}/${BROWSER}/${ALBUM}.pls" "Length${PLS}=-1"
		PLS=$[ $PLS + 1 ]
		echo -en "${GREEN}.${NORMAL}"
	done
	echo ""
done


echo -e "${GREEN}Creating ${BOLD}.jpg${NORMAL}${GREEN} image for each song.${NORMAL}"

for ALBUM in $ALBUMLIST
do
	cp -f ${LIBRARY}/${BROWSER}/zip.php ${LIBRARY}/${BROWSER}/${ALBUM}.php

	if [ "$GENERATE_PODS" == "0" ]
	then
		echo -en "${BOLD}${ALBUM}${NORMAL}"
	else
	echo -en "${BOLD}${ALBUM}${NORMAL}"
	THECOVER="${LIBRARY}/${ALBUM}/${COVER_SOURCE}"
	for FILE in `for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done`
        do
		SONGFILE="`basename "${FILE}"`"
		if [ -s "${LIBRARY}/${BROWSER}/${ALBUM}_data/${SONGFILE}.jpg" ]
		then
			true
		else
			THECOVER="${LIBRARY}/${ALBUM}/${COVER_SOURCE}"
			convert "${LIBRARY}/${BROWSER}/${ALBUM}_background.png" \
				-draw "image over ${COVER_POSITION} ${COVER_SIZE} '${THECOVER}'" \
				-font ${FONT} -pointsize ${TITLE_SIZE} \
			                -draw "fill black text $TITLE_POSITION2 '`get_title`' fill ${TITLE_COLOUR} text $TITLE_POSITION '`get_title`'" \
			        -pointsize ${ARTIST_SIZE} \
			                -draw "fill black text $ARTIST_POSITION2 '`get_artist`' fill ${ARTIST_COLOUR} text $ARTIST_POSITION '`get_artist`'" \
				-pointsize ${TRACK_NUMBER_SIZE} \
					-draw "fill $TRACK_NUMBER_COLOUR text $TRACK_NUMBER_POSITION 'Track `get_track_number`'" \
				-pointsize $TRACK_NAME_SIZE \
	                		-draw "fill $TRACK_NAME_COLOUR text $TRACK_NAME_POSITION '`get_track_name`'" \
				-quality $JPG_QUALITY \
			"${LIBRARY}/${BROWSER}/${ALBUM}_data/${SONGFILE}.jpg"
		fi
		echo -en "${GREEN}.${NORMAL}"
	
        done
	fi
        echo ""
done

echo -e "${GREEN}Creating per-album ${BOLD}.html${NORMAL}${GREEN} files.${NORMAL}"

for ALBUM in $ALBUMLIST
do
	# break
	echo -en "${BOLD}${ALBUM}${NORMAL}"
		# ok, this is where we actually do some work.
FILE="`for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done|head -n 1`"
cat <<EOF >${LIBRARY}/${BROWSER}/${ALBUM}.html
<html>
        <head>
                <link rel="StyleSheet" type="text/css" href="item.css"/>
                <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
                <title>`get_title`</title>
                <script type="text/javascript">
var baseFilename = "${ALBUM}";
//
  var title = 1;
  var lnk = 1;
  function lnkt() {
    if ( title == 1 ) title = document.getElementById('title').firstChild;
    if ( lnk == 1 ) lnk = document.getElementById('playLink');
  }
  function show(x) {
    lnkt();
    title.nodeValue = document.getElementById('title'+x).firstChild.nodeValue;
    if(lnk)lnk.setAttribute('HREF', baseFilename + '.playlist' + x + '.jsp');
  }
  function hide() {
    lnkt();
    title.nodeValue = "-";
    if(lnk)lnk.setAttribute('HREF', '');
  }
//
                </script>
                <script type="text/javascript" src="swf/swfobject.js"></script>
                <script type="text/javascript" src="swf/audio-player.js"></script>
                <script type="text/javascript">
             AudioPlayer.setup("${NMT_ROOT}/${BROWSER}/swf/player.swf", { width: 350, initialvolume: 100, transparentpagebg: "yes", leftbg: "000000", lefticon: "CCCCCC", text: "AAAAAA", track: "000000", bg: "000000", tracker: "333333", border: "444444", loader: "444444", skip: "FF8000" });
		</script>
		<script type="text/javascript">
                function playSelected(track) {
                AudioPlayer.embed("PlayAll",{autostart: "yes", soundFile: track});
                };
                </script>	
        </head>
        <body bgproperties="fixed" background="pictures/background-grey.jpg" onloadset="Play">
                <table class="main" align="center" border="0" cellpadding="0" cellspacing="0">
                        <tr height="30">
                                <td height="50" align="center" colspan="2">
                                        <a TVID="HOME" href="../index.htm"/>
                                        <a TVID="PGDN" href="Next_Album.html"/>
                                        <a TVID="PGUP" href="Prev_Album.html"/>
                                </td>
                        </tr>
                        <tr align="left" valign="top">
                                <td width="500px">
EOF
		FLASHPLAYLIST="<img src=\"${ALBUM}_large.png\" onClick=playSelected(\""
		for FILE in `for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done`
		do
			SONGFILE="`basename $FILE`"
			FLASHPLAYLIST="${FLASHPLAYLIST}${NMT_ROOT}/${ALBUM}/${SONGFILE},"
		done
		FLASHPLAYLIST_CHARS=`echo -n ${FLASHPLAYLIST}|wc -c`
		FLASHPLAYLIST=`echo -n ${FLASHPLAYLIST} | cut -b -$[ $FLASHPLAYLIST_CHARS - 1 ]|sed -e 's/&/%26/g'`
		echo -n "${FLASHPLAYLIST}" >>${LIBRARY}/${BROWSER}/${ALBUM}.html

cat <<EOF >>${LIBRARY}/${BROWSER}/${ALBUM}.html
"); />
                                        <center>
                                        <table>
                                                <tr>
                                                        <td class="title1" valign="top" colspan="2">
                                                                `get_title`
                                                        </td>
                                                <tr>
                                                        <td class="title2" colspan="2">
                                                                `get_artist`
                                                        </td>
                                                </tr>
                                                <tr class="divider" colspan="2">
                                                        <td width="150px">

                                                        </td>
                                                </tr>
                                                <tr class="spacer">
                                                        <td>

                                                        </td>
                                                </tr>
                                                <tr>
                                                        <td class="normal" width="45%">
                                                                `get_codec`
                                                        </td>
                                                <tr>
                                                        <td class="normal" width="45%">
                                                                `get_bitrate`
                                                        </td>
                                                </tr>
                                        </table>
                                        </center>
                                </td>
                                <td>
                                        <table border="0" width="85%">
                                                </tr>
                                                <tr>
                                                        <td>
                                                                <table>
                                                                        <tr>
                                                                                <td class="normal">
                                                                                <p id="PlayAll"><a class="link" onfocus="hide()" href="${NMT_ROOT}/${BROWSER}/${ALBUM}.pls" TVID="Play" name="Play" pod="2,1,${NMT_ROOT}/${BROWSER}/${ALBUM}_data/${ALBUM}.pod"><img src="pictures/play_small.png" onfocussrc="pictures/play_selected_small.png" align="top"/>Play all</a><div id="title"></div></p>
EOF
		FLASHPLAYLIST='<script type="text/javascript">AudioPlayer.embed("PlayAll", {soundFile: "'
		for FILE in `for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done`
		do
			SONGFILE="`basename $FILE`"
			FLASHPLAYLIST="${FLASHPLAYLIST}${NMT_ROOT}/${ALBUM}/${SONGFILE},"
		done
		FLASHPLAYLIST_CHARS=`echo -n ${FLASHPLAYLIST}|wc -c`
		FLASHPLAYLIST=`echo -n ${FLASHPLAYLIST} | cut -b -$[ $FLASHPLAYLIST_CHARS - 1 ]|sed -e 's/&/%26/g'`
		echo -n "${FLASHPLAYLIST}" >>${LIBRARY}/${BROWSER}/${ALBUM}.html

cat <<EOF >>${LIBRARY}/${BROWSER}/${ALBUM}.html
"});</script>
                                                                                </td>
                                                                                <td align="right">
                                                                                <a href="${NMT_ROOT}/${BROWSER}/${ALBUM}.php"><img src="pictures/zip.png" align="top" title="Download all files as single ZIP archive" /></a>
                                                                                </td>
                                                                                <td align="right">
                                                                                <a href="${NMT_ROOT}/${ALBUM}/"><img src="pictures/folder.png" align="top" title="Browse folder"/></a>
                                                                                </td>
EOF
if [ "$GENERATE_PODS" != "0" ]
then
cat <<EOF >>${LIBRARY}/${BROWSER}/${ALBUM}.html
                                                                                <td align="right">
                                                                                <a href="${NMT_ROOT}/${BROWSER}/${ALBUM}.pls"><img src="pictures/playlist.png" align="top" title="Download Playlist"/></a>
                                                                                </td>
EOF
fi
cat <<EOF >>${LIBRARY}/${BROWSER}/${ALBUM}.html

                                                                        </tr>

                                        <!-- TRACKS GO HERE -->
EOF

		ID=0
		for FILE in `for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done`
		do
		NEXTID=$[ $ID + 1 ]
		if [ "$ID" == "0" ]
		then
			PREVID="0"
		else
			PREVID="$[ $ID - 1 ]"
		fi
		SONGFILE="`basename $FILE`"
cat <<EOF >>${LIBRARY}/${BROWSER}/${ALBUM}.html
                                                                       <tr valign="top">
                                                                                <td class="normal">
											<img src="pictures/play_small_dimmed.png" onfocussrc="pictures/play_small.png" align="top" onClick=playSelected("${NMT_ROOT}/${ALBUM}/${SONGFILE}"); />
                                                                                        <a href="${NMT_ROOT}/${ALBUM}/${SONGFILE}" TVID="1" name="e${ID}" onkeyleftset="e${PREVID}" onkeyrightset="e${NEXTID}" onfocus="show(${NEXTID})" onblur="hide()" pod="2,1,${NMT_ROOT}/${BROWSER}/${ALBUM}_data/${SONGFILE}.pod">`get_track_number`. `get_track_name`</a>
                                                                                </td>
                                                                        </tr>

EOF
		ID="$[ $ID + 1 ]"
		echo -en "${GREEN}.${NORMAL}"
		done


cat <<EOF >>${LIBRARY}/${BROWSER}/${ALBUM}.html
                                        <!-- TRACKS END HERE -->
                                                                </table>
                                                        </td>
                                                </tr>
                                        </table>
                                </td>
                        </tr>
                </table>
        </body>
</html>
EOF

	echo ""
done

ALBUMCOUNT="`echo $ALBUMLIST | wc -w`"
MODULO="$[ ${ALBUMCOUNT} % ${CPP} ]"

if [ "${MODULO}" == "0" ]
then
	PAGECOUNT=$[ ${ALBUMCOUNT} / ${CPP} ]
else
	PAGECOUNT=$[ $[ ${ALBUMCOUNT} / ${CPP} ] + 1 ]
fi

if [ "${PAGECOUNT}" == "0" ]
then
	PAGECOUNT=1
fi

echo -e "${GREEN}Number of browser index pages required: ${PAGECOUNT} (at $CPP covers per page).${NORMAL}"

echo -e "${GREEN}Building pagemap.${NORMAL}"

PAGEMAP=`mktemp`
PAGEMAP_ALBUM="${PAGEMAP}-album"
PAGEMAP_ARTIST="${PAGEMAP}-artist"
COUNTER=1

# create pagemaps
for ALBUM in $ALBUMLIST
do
	FILE="`for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done |head -n 1`"
	echo "'$COUNTER'~'$ALBUM'~'`get_artist`'~'`get_title`'" >>$PAGEMAP
	COUNTER=$[ $COUNTER + 1 ]
done

COUNTER=1
for ALBUM in `cat $PAGEMAP | sed -e "s/'The\ //g" -e "s/'A\ //g" | sort -t '~' -k 3|cut -d '~' -f 2 | sed -e "s/'//g"`
do
	FILE="`for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done |head -n 1`"
        echo "'$COUNTER'~'$ALBUM'~'`get_artist`'~'`get_title`'" >>$PAGEMAP_ARTIST
	COUNTER=$[ $COUNTER + 1 ]
done

COUNTER=1
for ALBUM in `cat $PAGEMAP | sed -e "s/'The\ //g" -e "s/'A\ //g" | sort -t '~' -k 4|cut -d '~' -f 2 | sed -e "s/'//g"`
do
	FILE="`for TYPE in $FILE_TYPES ; do ls ${LIBRARY}/${ALBUM}/*.${TYPE} 2>/dev/null; done |head -n 1`"
        echo "'$COUNTER'~'$ALBUM'~'`get_artist`'~'`get_title`'" >>$PAGEMAP_ALBUM
	COUNTER=$[ $COUNTER + 1 ]
done

function pagemapalbum_title()
{
	grep "^'$ALBUMINDEX'~" $PAGEMAP_ALBUM | cut -d '~' -f 4 | cut -d "'" -f 2
}

function pagemapalbum_artist()
{
	grep "^'$ALBUMINDEX'~" $PAGEMAP_ALBUM | cut -d '~' -f 3 | cut -d "'" -f 2
}

function pagemapalbum_album()
{
	grep "^'$ALBUMINDEX'~" $PAGEMAP_ALBUM | cut -d '~' -f 2 | cut -d "'" -f 2
}

function divmapalbum_title()
{
	grep "^'$ALBUMINDEX2'~" $PAGEMAP_ALBUM | cut -d '~' -f 4 | cut -d "'" -f 2
}

function divmapalbum_artist()
{
	grep "^'$ALBUMINDEX2'~" $PAGEMAP_ALBUM | cut -d '~' -f 3 | cut -d "'" -f 2
}

function divmapalbum_album()
{
	grep "^'$ALBUMINDEX2'~" $PAGEMAP_ALBUM | cut -d '~' -f 2 | cut -d "'" -f 2
}

function pagemapartist_title()
{
	grep "^'$ALBUMINDEX'~" $PAGEMAP_ARTIST | cut -d '~' -f 4 | cut -d "'" -f 2
}

function pagemapartist_artist()
{
	grep "^'$ALBUMINDEX'~" $PAGEMAP_ARTIST  | cut -d '~' -f 3 | cut -d "'" -f 2
}

function pagemapartist_album()
{
	grep "^'$ALBUMINDEX'~" $PAGEMAP_ARTIST  | cut -d '~' -f 2 | cut -d "'" -f 2
}

function divmapartist_title()
{
	grep "^'$ALBUMINDEX2'~" $PAGEMAP_ARTIST  | cut -d '~' -f 4 | cut -d "'" -f 2
}

function divmapartist_artist()
{
	grep "^'$ALBUMINDEX2'~" $PAGEMAP_ARTIST  | cut -d '~' -f 3 | cut -d "'" -f 2
}

function divmapartist_album()
{
	grep "^'$ALBUMINDEX2'~" $PAGEMAP_ARTIST  | cut -d '~' -f 2 | cut -d "'" -f 2
}


echo "Generating Album-sorted pages"
echo "$CPR columns, $RPP rows, $CPP covers per page"
ROW=1
COLUMN=1
PAGE=1
ALBUMINDEX=1
ALBUMINDEX2=1
for PAGE in `seq 1 $PAGECOUNT`
do
	echo "Processing page $PAGE/$PAGECOUNT"	
	if [ "$PAGE" == "1" ]
	then
		NEXTPAGE=$[ $PAGE + 1 ]
		PREVPAGE=$PAGECOUNT
	elif [ "$PAGE" == $PAGECOUNT ]
	then
		NEXTPAGE="1"
		PREVPAGE=$[ $PAGE - 1 ]
	else
		PREVPAGE=$[ $PAGE - 1 ]
		NEXTPAGE=$[ $PAGE + 1 ]
	fi
cat <<EOF >${LIBRARY}/${BROWSER}/Album_${PAGE}.html
<html>
        <head>
                <link rel="StyleSheet" type="text/css" href="browse.css"/>
                <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/><title>$WEBPAGE_TITLE</title>
<script type="text/javascript">
var title = 1;
function show(x)
{
  if ( title == 1 )
    title = document.getElementById('title');
   title.firstChild.nodeValue = document.getElementById('title'+x).firstChild.nodeValue;
}
function hide(x)
{
  if ( title == 1 )
    title = document.getElementById('title');
   title.firstChild.nodeValue = "";
}
</script>
        </head>
        <body bgproperties="fixed" background="pictures/background-green.jpg" onloadset="1">
<!--                <a href="" tvid="#" id="play" vod="playlist"/> -->
                <table class="main" border="0" cellpadding="0" cellspacing="0">
                        <tr valign="top">
                                <td COLSPAN="2" align="center">
<!--                                        <a href="Album_09_1.html" name="09">09</a>
                                         - <a href="Album_A_1.html" name="A">A</a>
                                         - <a href="Album_B_1.html" name="B">B</a>
                                         - <a href="Album_C_1.html" name="C">C</a>
                                         - <a href="Album_D_1.html" name="D">D</a>
                                         - <a href="Album_E_1.html" name="E">E</a>
                                         - <a href="Album_F_1.html" name="F">F</a>
                                         - <a href="Album_G_1.html" name="G">G</a>
                                         - <a href="Album_H_1.html" name="H">H</a>
                                         - <a href="Album_I_1.html" name="I">I</a>
                                         - <a href="Album_J_1.html" name="J">J</a>
                                         - <a href="Album_K_1.html" name="K">K</a>
                                         - <a href="Album_L_1.html" name="L">L</a>
                                         - <a href="Album_M_1.html" name="M">M</a>
                                         - <a href="Album_N_1.html" name="N">N</a>
                                         - <a href="Album_O_1.html" name="O">O</a>
                                         - <a href="Album_P_1.html" name="P">P</a>
                                         - <a href="Album_Q_1.html" name="Q">Q</a>
                                         - <a href="Album_R_1.html" name="R">R</a>
                                         - <a href="Album_S_1.html" name="S">S</a>
                                         - <a href="Album_T_1.html" name="T">T</a>
                                         - <a href="Album_U_1.html" name="U">U</a>
                                         - <a href="Album_V_1.html" name="V">V</a>
                                         - <a href="Album_W_1.html" name="W">W</a>
                                         - <a href="Album_X_1.html" name="X">X</a>
                                         - <a href="Album_Y_1.html" name="Y">Y</a> -->
                                </td>
                        </tr>
                        <tr align="left" valign="top">
                                <td width="120">
                                        <table class="categories" border="0">
                                                <tr>
                                                        <td>
                                                                <a name="red" tvid="red" href="Artist_1.html">Artists</a>
                                                        <td>
                                                </tr>
                                                <tr>
                                                        <td>
                                                                <a name="green" tvid="green" href="Album_1.html">Albums</a>
                                                        <td>
                                                </tr>
                                                <tr>
                                                        <td>
                                                                <hr>
                                                        </td>
                                                </tr>
                                                <tr>
                                                        <td align="right"><table><tr><td valign="center">
                                                                <div class="counter">${PAGE} / ${PAGECOUNT}</div>
                                                        </td>
                                                        <td valign="top">
                                                                <a name="pgdn" tvid="pgdn" href="Album_$NEXTPAGE.html"><img src="pictures/nav_down.png"/></a>
                                                                <a name="pgup" tvid="pgup" href="Album_$PREVPAGE.html"><img src="pictures/nav_up.png"/></a>
                                                        </td>
                                                </tr>
                                        </table>
                                </td>
                        </tr>
                </table>
        </td>
        <td>
                <table class="movies" border="0">
EOF
	COUNTER=1
	for ROW in `seq 1 $RPP`
	do
		echo "	Processing row $ROW/$RPP"
cat <<EOF >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html
                        <tr>
EOF
		for COLUMN in `seq 1 $CPR`
		do
			echo "		Processing column $COLUMN/$CPR"
cat <<EOF >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html
                        	<td>
EOF
			if [ $ALBUMINDEX -le $ALBUMCOUNT ]
			then
cat <<EOF >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html
                                        <a href="`pagemapalbum_album`.html" TVID="$COUNTER" name="$COUNTER" onfocus="show($COUNTER)" onblur="hide($COUNTER)"><img src="`pagemapalbum_album`_small.png" onmouseover="show($COUNTER)" onmouseout="hide($COUNTER)"/></a>
EOF
			else
				echo "<!-- EMPTY -->" >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html

			fi
			ALBUMINDEX=$[ $ALBUMINDEX + 1 ]
			COUNTER=$[ $COUNTER + 1 ]
cat <<EOF >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html
                        	</td>
EOF
		done
cat <<EOF >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html
                        </tr>
EOF
	done
	

cat <<EOF >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html
                </table>
                <br/>
                <center>
                <table class="title" width="100%"><tr><td id="title" align="center"> </td></tr></table></td></tr></table>
EOF
	COUNTER=1
	for ROW in `seq 1 $RPP`
	do
		for COLUMN in `seq 1 $CPR`
		do
			if [ $ALBUMINDEX2 -le $ALBUMCOUNT ]
			then
				echo "                <div class="title" id="title${COUNTER}">`divmapalbum_title` by `divmapalbum_artist`</div>" >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html
			else
				echo "<!-- EMPTY -->" >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html

			fi
			ALBUMINDEX2=$[ $ALBUMINDEX2 + 1 ]
			COUNTER=$[ $COUNTER + 1 ]
		done
	done


cat <<EOF >>${LIBRARY}/${BROWSER}/Album_${PAGE}.html
                <div class="title">
                        <a TVID="HOME" href="../index.htm">Home</a>
                        <a name="pgdnload" onfocusload="" href="Album_$NEXTPAGE.html"/><a name="pgupload" onfocusload="" href="Album_$PREVPAGE.html"/>
                </div>
                </center>
        </body>
</html>
EOF

done
echo "Generating Artist-sorted pages"
echo "$CPR columns, $RPP rows, $CPP covers per page"
ROW=1
COLUMN=1
PAGE=1
ALBUMINDEX=1
ALBUMINDEX2=1
for PAGE in `seq 1 $PAGECOUNT`
do
	echo "Processing page $PAGE/$PAGECOUNT"	
	if [ "$PAGE" == "1" ]
	then
		NEXTPAGE=$[ $PAGE + 1 ]
		PREVPAGE=$PAGECOUNT
	elif [ "$PAGE" == $PAGECOUNT ]
	then
		NEXTPAGE="1"
		PREVPAGE=$[ $PAGE - 1 ]
	else
		PREVPAGE=$[ $PAGE - 1 ]
		NEXTPAGE=$[ $PAGE + 1 ]
	fi
cat <<EOF >${LIBRARY}/${BROWSER}/Artist_${PAGE}.html
<html>
        <head>
                <link rel="StyleSheet" type="text/css" href="browse.css"/>
                <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/><title>$WEBPAGE_TITLE</title>
<script type="text/javascript">
var title = 1;
function show(x)
{
  if ( title == 1 )
    title = document.getElementById('title');
   title.firstChild.nodeValue = document.getElementById('title'+x).firstChild.nodeValue;
}
function hide(x)
{
  if ( title == 1 )
    title = document.getElementById('title');
   title.firstChild.nodeValue = "";
}
</script>
        </head>
        <body bgproperties="fixed" background="pictures/background-red.jpg" onloadset="1">
<!--                <a href="" tvid="#" id="play" vod="playlist"/> -->
                <table class="main" border="0" cellpadding="0" cellspacing="0">
                        <tr valign="top">
                                <td COLSPAN="2" align="center">
<!--                                        <a href="Artist_09_1.html" name="09">09</a>
                                         - <a href="Artist_A_1.html" name="A">A</a>
                                         - <a href="Artist_B_1.html" name="B">B</a>
                                         - <a href="Artist_C_1.html" name="C">C</a>
                                         - <a href="Artist_D_1.html" name="D">D</a>
                                         - <a href="Artist_E_1.html" name="E">E</a>
                                         - <a href="Artist_F_1.html" name="F">F</a>
                                         - <a href="Artist_G_1.html" name="G">G</a>
                                         - <a href="Artist_H_1.html" name="H">H</a>
                                         - <a href="Artist_I_1.html" name="I">I</a>
                                         - <a href="Artist_J_1.html" name="J">J</a>
                                         - <a href="Artist_K_1.html" name="K">K</a>
                                         - <a href="Artist_L_1.html" name="L">L</a>
                                         - <a href="Artist_M_1.html" name="M">M</a>
                                         - <a href="Artist_N_1.html" name="N">N</a>
                                         - <a href="Artist_O_1.html" name="O">O</a>
                                         - <a href="Artist_P_1.html" name="P">P</a>
                                         - <a href="Artist_Q_1.html" name="Q">Q</a>
                                         - <a href="Artist_R_1.html" name="R">R</a>
                                         - <a href="Artist_S_1.html" name="S">S</a>
                                         - <a href="Artist_T_1.html" name="T">T</a>
                                         - <a href="Artist_U_1.html" name="U">U</a>
                                         - <a href="Artist_V_1.html" name="V">V</a>
                                         - <a href="Artist_W_1.html" name="W">W</a>
                                         - <a href="Artist_X_1.html" name="X">X</a>
                                         - <a href="Artist_Y_1.html" name="Y">Y</a> -->
                                </td>
                        </tr> 
                        <tr align="left" valign="top">
                                <td width="120">
                                        <table class="categories" border="0">
                                                <tr>
                                                        <td>
                                                                <a name="red" tvid="red" href="Artist_1.html">Artists</a>
                                                        <td>
                                                </tr>
                                                <tr>
                                                        <td>
                                                                <a name="green" tvid="green" href="Album_1.html">Albums</a>
                                                        <td>
                                                </tr>
                                                <tr>
                                                        <td>
                                                                <hr>
                                                        </td>
                                                </tr>
                                                <tr>
                                                        <td align="right"><table><tr><td valign="center">
                                                                <div class="counter">${PAGE} / ${PAGECOUNT}</div>
                                                        </td>
                                                        <td valign="top">
                                                                <a name="pgdn" tvid="pgdn" href="Artist_$NEXTPAGE.html"><img src="pictures/nav_down.png"/></a>
                                                                <a name="pgup" tvid="pgup" href="Artist_$PREVPAGE.html"><img src="pictures/nav_up.png"/></a>
                                                        </td>
                                                </tr>
                                        </table>
                                </td>
                        </tr>
                </table>
        </td>
        <td>
                <table class="movies" border="0">
EOF
	COUNTER=1
	for ROW in `seq 1 $RPP`
	do
		echo "	Processing row $ROW/$RPP"
cat <<EOF >>${LIBRARY}/${BROWSER}/Artist_${PAGE}.html
                        <tr>
EOF
		for COLUMN in `seq 1 $CPR`
		do
			echo "		Processing column $COLUMN/$CPR"
cat <<EOF >>${LIBRARY}/${BROWSER}/Artist_${PAGE}.html
                        	<td>
EOF
			if [ $ALBUMINDEX -le $ALBUMCOUNT ]
			then
cat <<EOF >>${LIBRARY}/${BROWSER}/Artist_${PAGE}.html
                                        <a href="`pagemapartist_album`.html" TVID="$COUNTER" name="$COUNTER" onfocus="show($COUNTER)" onblur="hide($COUNTER)"><img src="`pagemapartist_album`_small.png" onmouseover="show($COUNTER)" onmouseout="hide($COUNTER)"/></a>
EOF
			else
				echo "<!-- EMPTY -->" >>${LIBRARY}/${BROWSER}/Artist_${PAGE}.html

			fi
			ALBUMINDEX=$[ $ALBUMINDEX + 1 ]
			COUNTER=$[ $COUNTER + 1 ]
cat <<EOF >>${LIBRARY}/${BROWSER}/Artist_${PAGE}.html
                        	</td>
EOF
		done
cat <<EOF >>${LIBRARY}/${BROWSER}/Artist_${PAGE}.html
                        </tr>
EOF
	done
	

cat <<EOF >>${LIBRARY}/${BROWSER}/Artist_${PAGE}.html
                </table>
                <br/>
                <center>
                <table class="title" width="100%"><tr><td id="title" align="center"> </td></tr></table></td></tr></table>
EOF
	COUNTER=1
	for ROW in `seq 1 $RPP`
	do
		for COLUMN in `seq 1 $CPR`
		do
			if [ $ALBUMINDEX2 -le $ALBUMCOUNT ]
			then
				echo "                <div class="title" id="title${COUNTER}">`divmapartist_artist` - `divmapartist_title`</div>" >>${LIBRARY}/${BROWSER}/Artist_${PAGE}.html
			else
				echo "<!-- EMPTY -->" >>${LIBRARY}/${BROWSER}/Artist_${PAGE}.html

			fi
			ALBUMINDEX2=$[ $ALBUMINDEX2 + 1 ]
			COUNTER=$[ $COUNTER + 1 ]
		done
	done


cat <<EOF >>${LIBRARY}/${BROWSER}/Artist_${PAGE}.html
                <div class="title">
                        <a TVID="HOME" href="../index.htm">Home</a>
                        <a name="pgdnload" onfocusload="" href="Artist_$NEXTPAGE.html"/><a name="pgupload" onfocusload="" href="Artist_$PREVPAGE.html"/>
                </div>
                </center>
        </body>
</html>
EOF

done


rm -f $PAGEMAP $PAGEMAP_ARTIST $PAGEMAP_ALBUM
