<?php 
/*
  +----------------------------------------------------------------------+
  | Uploadprogress extension                                             |
  +----------------------------------------------------------------------+
  | Copyright (c) 2006-2008 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt.                                 |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Christian Stocker (chregu@php.net)                           |
  +----------------------------------------------------------------------+
*/

  $id = md5(microtime() . rand());
  
  function return_bytes($val) {
    $val = trim($val);
    $last = strtolower($val[strlen($val)-1]);
    switch($last) {
        // The 'G' modifier is available since PHP 5.1.0
        case 'g':
            $val *= 1024;
        case 'm':
            $val *= 1024;
        case 'k':
            $val *= 1024;
    }

    return $val;
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta name="generator" content="HTML Tidy for Linux/x86 (vers 1 September 2005), see www.w3.org" />
<script type="text/javascript">


var UP = function() {
    
    /* private variables */
    
    var ifr = null;
    
    var startTime = null;
    var upload_max_filesize = <?php echo return_bytes(ini_get('upload_max_filesize'));?>;
    
    var infoUpdated = 0;
    
    var writeStatus = function(text,color) {
        var statDiv = document.getElementById("status");
        if (color == 1 ) {
            statDiv.style.backgroundColor = "green";
        } else if (color == 2 ) {
            statDiv.style.backgroundColor = "orange";
        } else if (color == 3 ) {
            statDiv.style.backgroundColor = "red";
        } else {
            statDiv.style.backgroundColor = "white";
        }
        statDiv.innerHTML = text;
    }
    
    
    return {
        start: function() {
           ifr = document.getElementById("ifr");
           startTime = new Date();
           infoUpdated = 0;
           this.requestInfo();
        },
        stop: function(files) {
           if (typeof files == 'undefined' || files) {
                var secs = (new Date() - startTime)/1000;
                var statusText = "Upload succeeded, it took " + secs + " seconds. <br/> ";
                if (infoUpdated > 0) {
                    writeStatus(statusText + "",1);
                } else {
                    statusText += "<br/> ";
                    if (secs < 3) {
                      writeStatus(statusText + "Short mode.",2);
                    } else {
                      writeStatus(statusText + "Quiet mode.",3);
                    }
                        
                    
                    
                } 
           } else {
               writeStatus('PHP did not report any uploaded file, maybe it was too large, try a smaller one (post_max_size: <?php echo ini_get('post_max_size');?>)',3);
           }
           startTime = null;
        },
        requestInfo: function() {
                ifr.src="info.php?ID=<?php echo $id;?>&"+new Date();
        },
        
        updateInfo: function(uploaded, total, estimatedSeconds) {
            if (startTime) {
                if (uploaded) {
                    infoUpdated++;
                    if (total > upload_max_filesize) {
                        writeStatus("The file is too large and won't be available for PHP after the upload<br/> Your file size is " + total + " bytes. Allowed is " + upload_max_filesize + " bytes. That's " + Math.round (total / upload_max_filesize * 100) + "% too large<br/> Download started since " + (new Date() - startTime)/1000 + " seconds. " + Math.floor(uploaded / total * 100) + "% done, " + estimatedSeconds + "  seconds to go",2);
                    } else {
                        writeStatus("Download started since " + (new Date() - startTime)/1000 + " seconds. " + Math.floor(uploaded / total * 100) + "% done, " + estimatedSeconds + "  seconds to go");
                    }
                } else {
                    writeStatus("Download started since " + (new Date() - startTime)/1000 + " seconds. No progress info yet");
                }
                window.setTimeout("UP.requestInfo()",1000);
            }
        }
        
        
    }

}()


</script>
<title>Uploader</title>

</head>

<body background="background-white.jpg">

<h2>Upload interface</h2>
  <form onsubmit="UP.start()" target="ifr2" action="server.php" enctype="multipart/form-data" method="post">
    <input type="hidden" name="UPLOAD_IDENTIFIER" value="<?php echo $id;?>" /> 
    <p><b>1)</b> Choose a file to upload: <input type="file" name="file" />
    <br/>
<!--    <label>Select File:</label> 
    <input type="file" name="file2" />
    
    <br/>
    -->
    <b>2)</b> <i>If</i> you'd like an email receipt enter your address: <input name="email" type="text" /><sup>(see Note6)</sup><br>
    <b>3)</b> Click the <input type="submit" value="Upload" /> button.</p>
    <p>Once you click the Upload button, do not reload the page, do not press "Back", "Forward" or "Stop" buttons in your browser.</p>

   <?php
   
  
  $templateini =  ini_get("uploadprogress.file.filename_template");
  $testid = "<?php md5(microtime(true));";
  $template = sprintf($templateini,$testid);
  $templateerror = false;
  if ($template && $template != $templateini && @touch ($template) && file_exists($template)) {
    //    print '('.$templateini.' is writable. The realpath is ' . str_replace($testid,"%s",realpath($template)) .')';  
        unlink($template);
  } else {
        $templateerror = true;   
  }
  
  ?>
   </form>
   <div id="status" style="border: 1px black solid;<?php
   if (function_exists("uploadprogress_get_info")) {  
       if ($templateerror) {
           print 'background-color: red;"';
           print ">Problem. ";
           if ($template == $templateini) {
               print "uploadprogress.file.filename_template ($templateini) doesn't have an %s in it for making unique temporary files. Please adjust.<br/>";
           } else {
               print "$templateini is NOT writable. <br/>Please make sure the directory exists and is writable for the webserver. <br/>
               Or adjust the ini setting 'uploadprogress.file.filename_template' to a correct path.";
           }
       } else {
           print 'background-color: green;">Ready to upload.';
       }
       
       
   } else { ?>
       
       background-color: red;">The uploadprogress extension is not installed.
       
       
   <?php } ?>
   
  </div>
  
  
  
  <p>Upload information:</p>
  <iframe id="ifr" src="info.php?ID=<?php echo $id;?>" width="700px" height="60px" name="ifr"></iframe>
  
  <div>

  <p>Confirmations:</p>
  </div>
  <iframe name="ifr2" width="700px" height="160px" id="ifr2"></iframe>

<h3>How to prepare your upload:</h3>
<p><b>1)</b> Rip your CD with the best quality settings possible:
<li>256kbps MP3 is a good start, 320kbps even better,</li>
<li>other formats like OGG, M4A will also work,</li>
<li>for best results rip to FLAC,</li>
<li>no WMA please.</li>
<p><b>2)</b> Check that all tracks have correct ID3 tags<sup><sub>(see Note3)</sub></sup>:
<li>title,</li>
<li>artist,</li>
<li>album,</li>
<li>year,</li>
<li>track number (for each track).</li>
<p><b>3)</b> Create a folder called <tt>Artist_Name-Album_Title</tt>, put all the mp3 files there.</p>
<p><b>4)</b> Download the coverart (use <a href="http://images.google.co.uk/">Google Image Search</a>) minimum size 300x300 pixels. Save it inside that folder as <tt>cover.jpg</tt> (all lowercase).</p>
<p><b>5)</b> ZIP (or tar) the entire folder and upload above. Avoid spaces or other 'funny' characters in the name (underscores are fine).</p>
<h4>Note1:</h4>
<p>The ZIP (or tar) archive <b>must contain a folder</b> (or folders) inside. If the archive contains just files, it will be discarded. Examples:</p>
<h5>Good:</h5>
<tt>
Album_Title-Artist_Name.zip<br>
+ Album_Title-Artist_Name/<br>
+- 01-Track_One.mp3<br>
+- 02-Track_Two.mp3<br>
+- 03-Track_Three.mp3<br>
+- cover.jpg<br>
</tt>
<h5>Bad:</h5>
<tt>
Album_Title-Artist_Name.zip<br>
+ 01-Track_One.mp3<br>
+ 02-Track_Two.mp3<br>
+ 03-Track_Three.mp3<br>
+ cover.jpg<br>
</tt>
<p>If in doubt, open the ZIP (or tar) file. If you see a folder (or folders) inside, it's good. If you see files, it's bad.</p>
<h4>Note2:</h4>
<p>A single archive can contain multiple albums (each in separate folder). Example:</p>
<tt>
Two_Albums_Pack1.zip<br>
+ Album_Title-Artist_Name/<br>
+- 01-Track_One.mp3<br>
+- 02-Track_Two.mp3<br>
+- 03-Track_Three.mp3<br>
+- cover.jpg<br>
+ Another_Album_Title-Another_Artist/<br>
+- 01-Track_Foo.mp3<br>
+- 02-Track_Bar.mp3<br>
+- 03-Track_Baz.mp3<br>
+- cover.jpg<br>
</tt>
<h4>Note3:</h4>
<p>Most modern rippers will automatically tag the songs -- you don't have to do anything if you're using Windows Media Player, iTunes or gRip (or other open source rippers with CDDB support) but if you need a ID3 tag editor, try <a href="AudioTT-1.4.2.zip">AudioTT</a> a no-cost, cross-platform java-based editor. Another choice is <a href="http://easytag.sourceforge.net/">EasyTAG</a> on non-Windows platforms. On GNU/Linux systems it'll be most likely already available in your distribution's repositories so you don't have to download it manually. Best results so far can be achieved with <a href="http://sourceforge.net/projects/amarok-14/">Amarok 1.4.x</a>. It's old software (now superseded by Amarok 2.0 which should be avoided like teeth rot) but works extremely well as an ID3 tagger and file organiser.</p>
<h4>Note4:</h4>
<p>If you're using Windows, it is a good idea to disable hiding of known file extensions -- this way you can see the full names of files (<i>Tools</i> menu -&gt; <i>Folder options</i> -&gt; <i>View</i> tab -&gt; untick <i>Hide extensions for known file types</i> option).</p>
<h4>Note5:</h4>
<p>Only upload <b>complete</b> albums. No pick-and-choose.</p>
<h4>Note6:</h4>
<p>The email address will not be saved on the server -- it will only be used to send a one-off confirmation of a successful download or inform you of an error.</p>


</body>

</html>

