#!/bin/bash

############################################################################
#    Copyright (C) 2008-2009 by Jaroslaw Zachwieja <grok@zyxxyz.eu>        #
#                                                                          #
#    This program is free software; you can redistribute it and#or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 3 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

CD_DEVICE=/dev/sr1
TARGET=/storage/media/music
ARTIST="`/sbin/cripple --device ${CD_DEVICE} -q 2>&1|grep artist:|cut -d ':' -f 2-|sed -e 's/\ //g'`"
ALBUM="`/sbin/cripple --device ${CD_DEVICE} -q 2>&1|grep album:|cut -d ':' -f 2-|sed -e 's/\ //g'`"

if [ -d "${TARGET}/${ARTIST}"/"${ALBUM}" ]
then
        echo "${ARTIST}"/"${ALBUM} already ripped. aborting."
        eject ${CD_DEVICE}
        sleep 10
else
        echo "Ripping ${ARTIST}"/"${ALBUM}."
        mkdir -p "${TARGET}/${ARTIST}"/"${ALBUM}"
        nice -n 10 /sbin/cripple --device ${CD_DEVICE} --eject --fat -c clever --encoder-opts '--preset extreme' -p "${TARGET}/${ARTIST}/${ALBUM}" 2>&1 >/dev/tty9
        eject ${CD_DEVICE}
        sleep 10
fi