#!/bin/bash

MOVIE="`ls $1`"
echo $MOVIE
SHOWNAME=$2
BASENAME="`basename ${MOVIE} .mkv`"
METADATA_SOURCE="/storage/m/jukebox/Browse"
JUKEBOX_DESTINATION="/storage/m/tvix/tvshows"
SEASONLESS="`echo $SHOWNAME | cut -d '.' -f 1`"
RELATIVE_PATH="../../../tv/${SEASONLESS}"

OUTPUT="TViX.png"
METADATA="${METADATA_SOURCE}/${BASENAME}.xml"
BACKGROUND="./tvix-background.png"
COVER="${METADATA_SOURCE}/${BASENAME}_large.png"
FOLDER_SOURCE="${METADATA_SOURCE}/${BASENAME}.jpg"
COVER_POSITION="35,190"
COVER_SIZE="320,530"
FONT="Calibri-Regular"
IMAGE_SIZE="1280x720"
TITLE_SIZE="50"
PLOT_SIZE="700x"
PLOT_FONT_SIZE="25"
PLOT_POSITION="400,255"
PLOT_COLOUR="white"
TITLE_COLOUR="gold"
YEAR_COLOUR="gold"
YEAR_SIZE="40"
LINE_TOP_COLOUR="white"
LINE_TOP_START="400,225"
LINE_TOP_END="1240,225"
LINE_BOTTOM_COLOUR="white"
LINE_BOTTOM_START="400,500"
LINE_BOTTOM_END="1240,500"
TITLE_POSITION="400,220"
RATING_FILE="./rating_"
YEAR_POSITION="1150,220"
TITLE="`grep \<title\> $METADATA | cut -d ">" -f 2- | cut -d "<" -f 1 | sed -e "s/'//g"`"
PLOT="`grep \<plot\> $METADATA | cut -d ">" -f 2- | cut -d "<" -f 1 | sed -e "s/'//g"`"
YEAR="`grep \<year\> $METADATA | cut -d ">" -f 2- | cut -d "<" -f 1 | sed -e "s/'//g"`"
RATING="`grep \<rating\> $METADATA | cut -d ">" -f 2- | cut -d "<" -f 1 | sed -e "s/'//g"`"
RATING_COLOUR="white"
RATING_POSITION="1000,560"
RST=$[${RATING}/10]
STAR=$[${RST}*10]
RATING_PIC="${RATING_FILE}${STAR}.png"
DIRECTOR="`grep \<director\> $METADATA | cut -d ">" -f 2- | cut -d "<" -f 1 | sed -e "s/'//g"`"
STUDIO="`grep \<company\> $METADATA | cut -d ">" -f 2- | cut -d "<" -f 1 | sed -e "s/'//g"`"
ACTOR1="`grep \<actor\> $METADATA | head -n 1 | tail -n 1 | cut -d ">" -f 2- | cut -d "<" -f 1 | sed -e "s/'//g"`"
ACTOR2="`grep \<actor\> $METADATA | head -n 2 | tail -n 1 | cut -d ">" -f 2- | cut -d "<" -f 1 | sed -e "s/'//g"`"
ACTOR3="`grep \<actor\> $METADATA | head -n 3 | tail -n 1 | cut -d ">" -f 2- | cut -d "<" -f 1 | sed -e "s/'//g"`"
ACTOR4="`grep \<actor\> $METADATA | head -n 4 | tail -n 1 | cut -d ">" -f 2- | cut -d "<" -f 1 | sed -e "s/'//g"`"
RUNTIME="`grep \<runtime\> $METADATA | cut -d ">" -f 2- | cut -d "<" -f 1 | sed -e "s/'//g"`"
RUNTIME_COLOUR="white"
RUNTIME_POSITION="1000,525"
FOLDER_IMAGE_SIZE="147x200"

rm -f $OUTPUT

if [ -a ${JUKEBOX_DESTINATION}/${BASENAME}/`basename ${OUTPUT} .png`.jpg ]
then
	true
	#echo "TViX page ${JUKEBOX_DESTINATION}/${BASENAME}/`basename ${OUTPUT} .png`.jpg already exists"
else
convert -size 1280x720 ${BACKGROUND} \
			-draw "image over ${COVER_POSITION} ${COVER_SIZE} '${COVER}'" \
			-font ${FONT} -pointsize ${TITLE_SIZE} \
				-draw "fill ${TITLE_COLOUR}    text ${TITLE_POSITION} '${TITLE}'" \
			-font ${FONT} -pointsize ${YEAR_SIZE} \
				-draw "fill ${YEAR_COLOUR}     text ${YEAR_POSITION} '${YEAR}'" \
			-font ${FONT} -pointsize ${PLOT_FONT_SIZE} \
				-draw "fill ${RUNTIME_COLOUR}  text ${RUNTIME_POSITION} 'runtime: ${RUNTIME}'" \
				-draw "fill ${RATING_COLOUR}   text ${RATING_POSITION}  '     imdb: ${RATING}'" \
				-draw "fill ${LINE_TOP_COLOUR} line ${LINE_TOP_START} ${LINE_TOP_END}" \
				-draw "fill ${LINE_BOTTOM_COLOUR} line ${LINE_BOTTOM_START} ${LINE_BOTTOM_END}" \
			${OUTPUT}

convert			-background black \
			-font ${FONT} \
			-fill ${PLOT_COLOUR} \
			-pointsize ${PLOT_FONT_SIZE} \
			-size ${PLOT_SIZE} \
			caption:"${PLOT}" \
			plot.png

convert			-background black \
			-font ${FONT} \
			-fill ${PLOT_COLOUR} \
			-pointsize ${PLOT_FONT_SIZE} \
			-size ${PLOT_SIZE} \
			caption:"With: ${ACTOR1}, ${ACTOR2}\n           ${ACTOR3}, ${ACTOR4}" \
			actors.png

convert			-background black \
			-font ${FONT} \
			-fill ${PLOT_COLOUR} \
			-pointsize ${PLOT_FONT_SIZE} \
			-size ${PLOT_SIZE} \
			caption:"By: ${DIRECTOR}\n${STUDIO}" \
			credits.png

composite 		-compose Screen -geometry +400+225 plot.png ${OUTPUT} \
			${OUTPUT}
composite 		-compose Screen -geometry +400+560 actors.png ${OUTPUT} \
			${OUTPUT}
composite 		-compose Screen -geometry +400+500 credits.png ${OUTPUT} \
			${OUTPUT}
composite 		-compose Screen -geometry +135+675 ${RATING_PIC} ${OUTPUT} \
			${OUTPUT}


convert ${OUTPUT} -quality 100 `basename ${OUTPUT} .png`.jpg

rm plot.png actors.png credits.png $OUTPUT

mkdir -p ${JUKEBOX_DESTINATION}/${SHOWNAME}
mv -f `basename ${OUTPUT} .png`.jpg ${JUKEBOX_DESTINATION}/${SHOWNAME}/
fi
if [ -a ${JUKEBOX_DESTINATION}/${SHOWNAME}/folder.jpg ]
then
	true
	#echo "Folder image ${JUKEBOX_DESTINATION}/${BASENAME}/folder.jpg already exists"
else
convert ${FOLDER_SOURCE} -scale ${FOLDER_IMAGE_SIZE} -quality 85 folder.jpg
mv -f folder.jpg ${JUKEBOX_DESTINATION}/${SHOWNAME}/
fi
if [ -a ${JUKEBOX_DESTINATION}/${SHOWNAME}/${BASENAME}.mkv ]
then
	true
	#echo "Softlink ${JUKEBOX_DESTINATION}/${BASENAME}/${BASENAME}.mkv already exists"
else
cd ${JUKEBOX_DESTINATION}/${SHOWNAME}/
rm -f ${JUKEBOX_DESTINATION}/${SHOWNAME}/${BASENAME}.mkv
#ln -s ${RELATIVE_PATH}/${BASENAME}.mkv .
for N in `ls ${RELATIVE_PATH}/${SHOWNAME}*.mkv`
do
	ln -s $N .
done
cd -
fi
