<?php

require("config.php");
require_once('getid3/getid3.php');

function array_sort_func($a,$b=NULL) {
   static $keys;
   if($b===NULL) return $keys=$a;
   foreach($keys as $k) {
      if(@$k[0]=='!') {
         $k=substr($k,1);
         if(@$a[$k]!==@$b[$k]) {
            return strcmp(@$b[$k],@$a[$k]);
         }
      }
      else if(@$a[$k]!==@$b[$k]) {
         return strcmp(@$a[$k],@$b[$k]);
      }
   }
   return 0;
}

function array_sort(&$array) {
   if(!$array) return $keys;
   $keys=func_get_args();
   array_shift($keys);
   array_sort_func($keys);
   usort($array,"array_sort_func");       
} 

if ( isset($_GET['page'])) {
	$page = $_GET['page'];
} else {
	$page = $defaults['page'];
}

if ( isset($_GET['order'])) {
	$order = $_GET['order'];
} else {
	$order = $defaults['order'];
}

if (isset($_GET['filter'])) {
	$filter = $_GET['filter'];
} else {
	$filter = "";
}

if (isset($_GET['start'])) {
	$start = $_GET['start'];
} else {
	$start = $defaults['start'];
}

if (isset($_GET['search'])) {
	$search = $_GET['search'];
} else {
	$search = "";
}

if (isset($_GET['r'])) {
	$recursive = $_GET['r'];
} else {
	$recursive = "";
}

function csv_explode($delim=',', $str, $enclose='"', $preserve=false){
  $resArr = array();
  $n = 0;
  $expEncArr = explode($enclose, $str);
  foreach($expEncArr as $EncItem){
    if($n++%2){
      array_push($resArr, array_pop($resArr) . ($preserve?$enclose:'') . $EncItem.($preserve?$enclose:''));
    }else{
      $expDelArr = explode($delim, $EncItem);
      array_push($resArr, array_pop($resArr) . array_shift($expDelArr));
      $resArr = array_merge($resArr, $expDelArr);
    }
  }
  return $resArr;
}

$newseconds = $settings['newseconds'];

$coversperrow = $settings['cpr'];
$rowsperpage = $settings['rpp'];
$wwwroot = $settings['wwwroot'];

$coversperpage = $coversperrow * $rowsperpage;
$smallcoversize = intval($settings['smallcoverarea'] / $coversperrow);

$counter = 0;
$albums = array();
$getID3 = new getID3;


while ( preg_match("/  /",$search) ) {
	$search = preg_replace("/  /"," ",$search);
}
if ( $search && ! $recursive ) {

	$search_array = array_unique(csv_explode(" ",$search));
	
	foreach ( array_keys($libraries) as $library ) {
	
		$dir_handle = @opendir($library);
		while ($dir = readdir($dir_handle)) {
			if ( $dir == ".." || $dir == "." || ! is_dir("$library/$dir") ) {
				continue;
			}
			$sorting = explode("_-_",$dir,2);
			$pattern = "/^".$filter."/";	
			if ( $page == "artist" ) {
				$subject = $sorting[0];
			} elseif ( $page == "album" ) {
				$subject = $sorting[1];
			} elseif ( $page == "time" ) {
				$subject = $sorting[0];
			} else {
				echo "ASSERT in page type";
				die;
			}
			$found_match = 0;
			foreach ( $search_array as $search_string ) {
				$search_string = preg_replace("/ /",".",$search_string);
				if (preg_match("/$search_string/i",$dir)) { 
					$found_match = 1; 
					break;
				}
			}
			if ( $found_match == 0 ) {
				$dir = ".";
			}
			if ( $dir != "." && $dir != ".." && $dir != ".Browse" && is_dir("$library/$dir") && preg_match("$pattern",preg_replace("/^A_/","",preg_replace("/^The_/","",$subject))) ) {
				$counter = $counter + 1;
				$urlpath = str_replace("$wwwroot", "/", "$library");
	
				$filepath = $library."/".$dir."/*.mp3";
				foreach ( glob("$filepath") as $file ) {
					break;
				}
				$albums [$counter]['sort_time'] = filemtime($file);
				$albums [$counter]['ondisk_artist'] = $sorting[0];
				$albums [$counter]['ondisk_album'] = $sorting[1];
				$albums [$counter]['sort_artist'] = preg_replace("/^A_/","",preg_replace("/^The_/","",$sorting[0]));
				$albums [$counter]['sort_album'] = preg_replace("/^A_/","",preg_replace("/^The_/","",$sorting[1]));
				$albums [$counter]['library'] = $library;
				$albums [$counter]['directory'] = $dir;
				$albums [$counter]['url'] = $urlpath."/".basename($dir);
				$albums [$counter]['firstfile'] = $file;
	
			}
		}
		closedir($dir_handle);
	
	}


} elseif ( ! $search && ! $recursive ) {



	foreach ( array_keys($libraries) as $library ) {
	
		$dir_handle = @opendir($library);
		while ($dir = readdir($dir_handle)) {
			if ( $dir == ".." || $dir == "." || ! is_dir("$library/$dir") ) {
				continue;
			}
			$sorting = explode("_-_",$dir,2);
			$pattern = "/^".$filter."/";	
//			echo $dir."\n";
//			print_r($sorting);
//			echo "\n";
			if ( $page == "artist" ) {
				$subject = $sorting[0];
			} elseif ( $page == "album" ) {
				$subject = $sorting[1];
			} elseif ( $page == "time" ) {
				$subject = $sorting[0];
			} else {
				echo "ASSERT in page type";
				die;
			}

			$dirpath = $library."/".$dir;
			$dirmtime = stat($dirpath);
			$dirtime = $dirmtime['9'];

			if ( $page == "time" ) {
				$oldest = time() - $newseconds; 
			} else {
				$oldest = 0;
			}

			if ( $dirtime > $oldest && $dir != "." && $dir != ".." && $dir != ".Browse" && is_dir("$library/$dir") && preg_match("$pattern",preg_replace("/^A_/","",preg_replace("/^The_/","",$subject))) ) {
				$counter = $counter + 1;
				$urlpath = str_replace("$wwwroot", "/", "$library");
	
				$filepath = $library."/".$dir."/*.mp3";
				foreach ( glob("$filepath") as $file ) {
					break;
				}
				$albums [$counter]['sort_time'] = filemtime($file);
				$albums [$counter]['ondisk_artist'] = $sorting[0];
				$albums [$counter]['ondisk_album'] = $sorting[1];
				$albums [$counter]['sort_artist'] = preg_replace("/^A_/","",preg_replace("/^The_/","",$sorting[0]));
				$albums [$counter]['sort_album'] = preg_replace("/^A_/","",preg_replace("/^The_/","",$sorting[1]));
				$albums [$counter]['library'] = $library;
				$albums [$counter]['directory'] = $dir;
				$albums [$counter]['url'] = $urlpath."/".basename($dir);
				$albums [$counter]['firstfile'] = $file;
	
			}
		}
		closedir($dir_handle);
	
	}
} elseif ( $search && $recursive ) {

	$search_array = array_unique(csv_explode(" ",$search));
	foreach ( array_keys($libraries) as $library ) {

	$dir_handle = @opendir($library);
	while ($dir = readdir($dir_handle)) {
		if ( $dir == ".." || $dir == "." || ! is_dir("$library/$dir") ) {
			continue;
		}
		$sorting = explode("_-_",$dir,2);
		$pattern = "/^".$filter."/";	
		if ( $page == "artist" ) {
			$subject = $sorting[0];
		} elseif ( $page == "album" ) {
			$subject = $sorting[1];
		} elseif ( $page == "time" ) {
			$subject = $sorting[0];
		} else {
			echo "ASSERT in page type";
			die;
		}
		$found_match = 0;
		if ( $dir != "." && $dir != ".." && $dir != ".Browse" && is_dir("$library/$dir") ) {
			$urlpath = str_replace("$wwwroot", "/", "$library");
			
			$filepath = $library."/".$dir."/*.mp3";
			foreach ( glob("$filepath") as $file ) {
				foreach ( $search_array as $search_string ) {
					$search_string = preg_replace("/ /",".",$search_string);
					if ( preg_match("/$search_string/i",$file) ) { 
						$found_match = 1; 
						break;
					}
				}
			}

                        $filepath = $library."/".$dir."/*.mp3";
                        foreach ( glob("$filepath") as $file ) {
                                break;
                        }
				
			if ( $found_match == 1 ) {
				
				$counter = $counter + 1;
				$albums [$counter]['sort_time'] = filemtime($file);
				$albums [$counter]['ondisk_artist'] = $sorting[0];
				$albums [$counter]['ondisk_album'] = $sorting[1];
				$albums [$counter]['sort_artist'] = preg_replace("/^A_/","",preg_replace("/^The_/","",$sorting[0]));
				$albums [$counter]['sort_album'] = preg_replace("/^A_/","",preg_replace("/^The_/","",$sorting[1]));
				$albums [$counter]['library'] = $library;
				$albums [$counter]['directory'] = $dir;
				$albums [$counter]['url'] = $urlpath."/".basename($dir);
				$albums [$counter]['firstfile'] = $file;

			}


		}
	}
	closedir($dir_handle);

}


} else {
	// ! $search && $recursive
	echo "You can't tell me to search recursively without a search term. Come on. Let's be adults.";
	die;
}

$sortkey = "sort_".$page;

if ( $sortkey == "sort_time" ) {
	$sortkey = "!sort_time";
}

array_sort($albums,$sortkey);

$albumcount = $counter;

$modulo = $albumcount% $coversperpage;

if ( $modulo == 0 ) {
	$pagecount = intval($albumcount / $coversperpage);
} else {
	$pagecount = intval($albumcount / $coversperpage) + 1;
}

$firstpage = 1;
$currentpage = $start;
$lastpage = $pagecount;

if ( $currentpage == $firstpage ) {
	$nextpage = $currentpage + 1;
	$prevpage = $lastpage;
} elseif ( $currentpage == $lastpage ) {
	$nextpage = $firstpage;
	$prevpage = $currentpage - 1;
} else {
	$nextpage = $currentpage + 1;
	$prevpage = $currentpage - 1;
}

if ( $pagecount == 1 ) {
	$nextpage = $currentpage;
	$prevpage = $currentpage;
}

require("res/html/browser.tpl");

$utf8_string = 'Iñtërnâtiônàlizætiøn';
if ( $search ) {
	foreach ( $search_array as $searchstring ) {
		if ( $recursive ) {
			echo "Track ";
		} else {
			echo "Album / Artist ";
		}
		echo "search results for: <b>".$searchstring."</b>\n";
	}
} else {
	echo "&nbsp;";
	if ($filter) {
		echo $page."s - <b>".$filter."</b>\n";
	}

}
 

echo "\t\t\t<tr>\n";

$row = 1;
$tempcounter = 1;
for ($i = ($currentpage * $coversperpage)-($coversperpage); $i < $albumcount; $i++) {
$coverart = $albums[$i]['url']."/".$settings['coverfile'];

	echo "\t\t\t\t<td>\n";

	$trans = array("&" => "%26");
	$safealbum = strtr($albums[$i]['directory'],$trans);

	echo "\t\t\t\t\t<a href=\"album.php?album=".$safealbum."\" name=\"".$tempcounter."\" onfocus=\"show(".$tempcounter.")\" onblur=\"hide(".$tempcounter.")\"><img src=\"image.php?album=".$safealbum."&size=".$smallcoversize."\" onmouseover=\"show(".$tempcounter.")\" onmouseout=\"hide(".$tempcounter.")\" WIDTH=".$smallcoversize." HEIGHT=".$smallcoversize." /></a>\n";

	$tempcounter = $tempcounter + 1;
	echo "\t\t\t\t</td>\n";
	if ( (($i+1) % $coversperrow) == 0) {
		echo "</tr>\n";
		echo "<tr>\n";
		$row = $row + 1;
	}
	if ( $row == $rowsperpage + 1) {
		break;
	}
	
}

echo "</tr>\n";
echo "\t\t</table>\n";
echo "\t\t<br/>\n";
echo "\t\t<center>\n";
echo "                <table class=\"title\" width=\"100%\"><tr><td id=\"title\" align=\"center\"> </td></tr></table></td></tr></table>\n";


$row = 1;
$tempcounter = 1;

for ($i = ($currentpage * $coversperpage)-($coversperpage); $i < $albumcount; $i++) {
	if ( (($i+1) % $coversperrow) == 0) {
		$row = $row + 1;
	}
	$fileinfo = $getID3->analyze($albums[$i]['firstfile']);
	$albums_sorted[$i]['album'] = @$fileinfo['tags']['id3v2']['album'][0];
	if ( ! $albums_sorted[$i]['album']) {
		$albums_sorted[$i]['album'] = @$fileinfo['tags']['id3v1']['album'][0];
	}
	$albums_sorted[$i]['artist'] = @$fileinfo['tags']['id3v2']['artist'][0];
	if ( ! $albums_sorted[$i]['artist'] ) {
	$albums_sorted[$i]['artist'] = @$fileinfo['tags']['id3v1']['artist'][0];
	}
	echo "                <div class=title id=title".$tempcounter.">".$albums_sorted[$i]['artist']." - ".$albums_sorted[$i]['album']."</div>\n";
	$tempcounter = $tempcounter + 1;
	if ( $row == $rowsperpage + 1) {
		break;
	}
}

echo "                <div class=\"title\">\n<a TVID=\"HOME\" href=\"browser.php\">Home</a>\n<a name=\"pgdnload\" onfocusload=\"\" href=\"browser.php?page=".$page."&start=".$nextpage."&order=".$order."&filter=".$filter."\"/><a name=\"pgupload\" onfocusload=\"\" href=\"browser.php?page=".$page."&start=".$prevpage."&order=".$order."&filter=".$filter."\"/>\n</div>\n</center>\n</body>\n</html>";


?>
