#!/bin/bash

############################################################################
#    Copyright (C) 2008-2009 by Jaroslaw Zachwieja <grok@zyxxyz.eu>        #
#                                                                          #
#    This program is free software; you can redistribute it and#or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 3 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################


DST=/storage/media/dvdrips
DEV=/dev/sr0

sleep 5
echo "$SRC"
/usr/bin/mplayer dvd:// -dvd-device ${DEV} -ss 1 -endpos 1 -identify -really-quiet -vo null -ao null
TITLE="`lsdvd $DEV | grep 'Disc Title:' | awk '{print $3}'`"
echo $TITLE

if [ -a "${SRC}/${TITLE}.iso" ]
then
        TITLE=""
fi
if [ "$TITLE" != "" ]
then
        echo "Found DVD: $TITLE. Ripping..."
        ionice -c 3 nice -n 10 dd if=${DEV} of=${DST}/${TITLE}.iso.partial bs=2k  || rm -f ${DST}/${TITLE}.iso.partial
        mv -f ${DST}/${TITLE}.iso.partial ${DST}/${TITLE}.iso
        echo "Ripping of $TITLE finished."
fi

sleep 5

eject ${DEV}
